/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.caps.model;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.TreeSet;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.core.stream.model.StreamFeature;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.model.info.Feature;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoNode;

@XmlRootElement(name="c")
public final class EntityCapabilities
extends StreamFeature {
    public static final String NAMESPACE = "http://jabber.org/protocol/caps";
    @XmlAttribute
    private final String hash;
    @XmlAttribute
    private final String node;
    @XmlAttribute
    private final String ver;

    private EntityCapabilities() {
        this.node = null;
        this.hash = null;
        this.ver = null;
    }

    public EntityCapabilities(String node, String hash, String ver) {
        this.node = Objects.requireNonNull(node);
        this.hash = Objects.requireNonNull(hash);
        this.ver = Objects.requireNonNull(ver);
    }

    public static String getVerificationString(InfoNode infoNode, MessageDigest messageDigest) {
        TreeSet identities = new TreeSet(infoNode.getIdentities());
        TreeSet features = new TreeSet(infoNode.getFeatures());
        ArrayList dataForms = new ArrayList(infoNode.getExtensions());
        StringBuilder sb = new StringBuilder();
        for (Identity identity : identities) {
            if (identity.getCategory() != null) {
                sb.append(identity.getCategory());
            }
            sb.append("/");
            if (identity.getType() != null) {
                sb.append(identity.getType());
            }
            sb.append("/");
            if (identity.getLanguage() != null) {
                sb.append(identity.getLanguage());
            }
            sb.append("/");
            if (identity.getName() != null) {
                sb.append(identity.getName());
            }
            sb.append("<");
        }
        for (Feature feature : features) {
            if (feature.getVar() != null) {
                sb.append(feature.getVar());
            }
            sb.append("<");
        }
        Collections.sort(dataForms);
        for (DataForm dataForm : dataForms) {
            ArrayList fields = new ArrayList(dataForm.getFields());
            Collections.sort(fields);
            if (fields.isEmpty() || !"FORM_TYPE".equals(((DataForm.Field)fields.get(0)).getVar()) || ((DataForm.Field)fields.get(0)).getType() != DataForm.Field.Type.HIDDEN) continue;
            for (DataForm.Field field : fields) {
                ArrayList values = new ArrayList(field.getValues());
                if (!"FORM_TYPE".equals(field.getVar())) {
                    sb.append(field.getVar());
                    sb.append("<");
                    Collections.sort(values);
                }
                for (String value : values) {
                    sb.append(value);
                    sb.append("<");
                }
            }
        }
        String plainString = sb.toString();
        messageDigest.reset();
        return DatatypeConverter.printBase64Binary((byte[])messageDigest.digest(plainString.getBytes()));
    }

    public final String getHashingAlgorithm() {
        return this.hash;
    }

    public final String getNode() {
        return this.node;
    }

    public final String getVerificationString() {
        return this.ver;
    }

    public final int getPriority() {
        return 0;
    }

    public final String toString() {
        return this.ver;
    }
}

