/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.geoloc.model;

import java.net.URI;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.extensions.time.model.TimeZoneAdapter;

@XmlRootElement(name="geoloc")
public final class GeoLocation {
    public static final String NAMESPACE = "http://jabber.org/protocol/geoloc";
    @XmlAttribute(name="lang", namespace="http://www.w3.org/XML/1998/namespace")
    private String language;
    @XmlElement(name="accuracy")
    private Double accuracy;
    @XmlElement(name="altitude")
    private Double altitude;
    @XmlElement(name="area")
    private String area;
    @XmlElement(name="bearing")
    private Double bearing;
    @XmlElement(name="building")
    private String building;
    @XmlElement(name="country")
    private String country;
    @XmlElement(name="countrycode")
    private String countryCode;
    @XmlElement(name="datum")
    private String datum;
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="floor")
    private String floor;
    @XmlElement(name="lat")
    private Double latitude;
    @XmlElement(name="locality")
    private String locality;
    @XmlElement(name="lon")
    private Double longitude;
    @XmlElement(name="postalcode")
    private String postalCode;
    @XmlElement(name="region")
    private String region;
    @XmlElement(name="room")
    private String room;
    @XmlElement(name="speed")
    private Double speed;
    @XmlElement(name="street")
    private String street;
    @XmlElement(name="text")
    private String text;
    @XmlElement(name="timestamp")
    private Date timestamp;
    @XmlJavaTypeAdapter(value=TimeZoneAdapter.class)
    @XmlElement(name="tzo")
    private TimeZone timeZone;
    @XmlElement(name="uri")
    private URI uri;

    public GeoLocation() {
    }

    private GeoLocation(Builder builder) {
        this.accuracy = builder.accuracy;
        this.altitude = builder.altitude;
        this.area = builder.area;
        this.bearing = builder.bearing;
        this.building = builder.building;
        this.country = builder.country;
        this.countryCode = builder.countryCode;
        this.datum = builder.datum;
        this.description = builder.description;
        this.floor = builder.floor;
        this.language = builder.language;
        this.latitude = builder.latitude;
        this.locality = builder.locality;
        this.longitude = builder.longitude;
        this.postalCode = builder.postalCode;
        this.region = builder.region;
        this.room = builder.room;
        this.speed = builder.speed;
        this.street = builder.street;
        this.text = builder.text;
        this.timestamp = builder.timestamp;
        this.timeZone = builder.timeZone;
        this.uri = builder.uri;
    }

    @Deprecated
    public GeoLocation(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public static Builder builder() {
        return new Builder();
    }

    public final Double getAccuracy() {
        return this.accuracy;
    }

    @Deprecated
    public void setAccuracy(Double accuracy) {
        this.accuracy = accuracy;
    }

    public final Double getAltitude() {
        return this.altitude;
    }

    @Deprecated
    public void setAltitude(Double altitude) {
        this.altitude = altitude;
    }

    public final String getArea() {
        return this.area;
    }

    @Deprecated
    public void setArea(String area) {
        this.area = area;
    }

    public final Double getBearing() {
        return this.bearing;
    }

    @Deprecated
    public void setBearing(Double bearing) {
        this.bearing = bearing;
    }

    public final String getBuilding() {
        return this.building;
    }

    @Deprecated
    public void setBuilding(String building) {
        this.building = building;
    }

    public final String getCountry() {
        return this.country;
    }

    @Deprecated
    public void setCountry(String country) {
        this.country = country;
    }

    public final String getCountryCode() {
        return this.countryCode;
    }

    @Deprecated
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public final String getDatum() {
        return this.datum;
    }

    @Deprecated
    public void setDatum(String datum) {
        this.datum = datum;
    }

    public final String getDescription() {
        return this.description;
    }

    @Deprecated
    public void setDescription(String description) {
        this.description = description;
    }

    public final String getFloor() {
        return this.floor;
    }

    @Deprecated
    public void setFloor(String floor) {
        this.floor = floor;
    }

    public final Double getLatitude() {
        return this.latitude;
    }

    @Deprecated
    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public final String getLocality() {
        return this.locality;
    }

    @Deprecated
    public void setLocality(String locality) {
        this.locality = locality;
    }

    public final Double getLongitude() {
        return this.longitude;
    }

    @Deprecated
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public final String getPostalCode() {
        return this.postalCode;
    }

    @Deprecated
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public final String getRegion() {
        return this.region;
    }

    @Deprecated
    public void setRegion(String region) {
        this.region = region;
    }

    public final String getRoom() {
        return this.room;
    }

    @Deprecated
    public void setRoom(String room) {
        this.room = room;
    }

    public final Double getSpeed() {
        return this.speed;
    }

    @Deprecated
    public void setSpeed(Double speed) {
        this.speed = speed;
    }

    public final String getStreet() {
        return this.street;
    }

    @Deprecated
    public void setStreet(String street) {
        this.street = street;
    }

    public final String getText() {
        return this.text;
    }

    @Deprecated
    public void setText(String text) {
        this.text = text;
    }

    public final Date getTimestamp() {
        return this.timestamp;
    }

    @Deprecated
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public final URI getUri() {
        return this.uri;
    }

    @Deprecated
    public void setUri(URI uri) {
        this.uri = uri;
    }

    public final String getLanguage() {
        return this.language;
    }

    @Deprecated
    public void setLanguage(String language) {
        this.language = language;
    }

    public final TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Deprecated
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder("Geolocation: ");
        if (this.accuracy != null) {
            sb.append("Accuracy: ");
            sb.append(this.accuracy);
            sb.append("; ");
        }
        if (this.altitude != null) {
            sb.append("Altitude: ");
            sb.append(this.altitude);
            sb.append("; ");
        }
        if (this.area != null) {
            sb.append("Area: ");
            sb.append(this.area);
            sb.append("; ");
        }
        if (this.bearing != null) {
            sb.append("Bearing: ");
            sb.append(this.bearing);
            sb.append("; ");
        }
        if (this.building != null) {
            sb.append("Building: ");
            sb.append(this.building);
            sb.append("; ");
        }
        if (this.country != null) {
            sb.append("Country: ");
            sb.append(this.country);
            sb.append("; ");
        }
        if (this.countryCode != null) {
            sb.append("Country Code: ");
            sb.append(this.countryCode);
            sb.append("; ");
        }
        if (this.datum != null) {
            sb.append("Datum: ");
            sb.append(this.datum);
            sb.append("; ");
        }
        if (this.description != null) {
            sb.append("Description: ");
            sb.append(this.description);
            sb.append("; ");
        }
        if (this.floor != null) {
            sb.append("Floor: ");
            sb.append(this.floor);
            sb.append("; ");
        }
        if (this.latitude != null) {
            sb.append("Latitude: ");
            sb.append(this.latitude);
            sb.append("; ");
        }
        if (this.locality != null) {
            sb.append("Locality: ");
            sb.append(this.locality);
            sb.append("; ");
        }
        if (this.longitude != null) {
            sb.append("Longitude: ");
            sb.append(this.longitude);
            sb.append("; ");
        }
        if (this.postalCode != null) {
            sb.append("Postal Code: ");
            sb.append(this.postalCode);
            sb.append("; ");
        }
        if (this.region != null) {
            sb.append("Region: ");
            sb.append(this.region);
            sb.append("; ");
        }
        if (this.room != null) {
            sb.append("Room: ");
            sb.append(this.room);
            sb.append("; ");
        }
        if (this.speed != null) {
            sb.append("Speed: ");
            sb.append(this.speed);
            sb.append("; ");
        }
        if (this.street != null) {
            sb.append("Street: ");
            sb.append(this.street);
            sb.append("; ");
        }
        if (this.text != null) {
            sb.append("Text: ");
            sb.append(this.text);
            sb.append("; ");
        }
        if (this.timestamp != null) {
            sb.append("Timestamp: ");
            sb.append(this.timestamp);
            sb.append("; ");
        }
        if (this.timeZone != null) {
            sb.append("Time Zone: ");
            sb.append(this.timeZone.getDisplayName());
            sb.append("; ");
        }
        if (this.uri != null) {
            sb.append("URI: ");
            sb.append(this.uri);
            sb.append("; ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    public static final class Builder {
        private String language;
        private Double accuracy;
        private Double altitude;
        private String area;
        private Double bearing;
        private String building;
        private String country;
        private String countryCode;
        private String datum;
        private String description;
        private String floor;
        private Double latitude;
        private String locality;
        private Double longitude;
        private String postalCode;
        private String region;
        private String room;
        private Double speed;
        private String street;
        private String text;
        private Date timestamp;
        private TimeZone timeZone;
        private URI uri;

        private Builder() {
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder accuracy(Double accuracy) {
            this.accuracy = accuracy;
            return this;
        }

        public Builder altitude(Double altitude) {
            this.altitude = altitude;
            return this;
        }

        public Builder area(String area) {
            this.area = area;
            return this;
        }

        public Builder bearing(Double bearing) {
            this.bearing = bearing;
            return this;
        }

        public Builder building(String building) {
            this.building = building;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder datum(String datum) {
            this.datum = datum;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder floor(String floor) {
            this.floor = floor;
            return this;
        }

        public Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder locality(String locality) {
            this.locality = locality;
            return this;
        }

        public Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder room(String room) {
            this.room = room;
            return this;
        }

        public Builder speed(Double speed) {
            this.speed = speed;
            return this;
        }

        public Builder street(String street) {
            this.street = street;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder timeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public GeoLocation build() {
            return new GeoLocation(this);
        }
    }
}

