/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc.model;

import java.util.ArrayList;
import rocks.xmpp.core.Jid;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.muc.model.Role;

public final class RequestVoice {
    private static final String FORM_TYPE = "http://jabber.org/protocol/muc#request";
    private static final String ROLE = "muc#role";
    private static final String JID = "muc#jid";
    private static final String ROOM_NICK = "muc#roomnick";
    private static final String REQUEST_ALLOW = "muc#request_allow";
    private final DataForm dataForm;

    public RequestVoice(DataForm dataForm) {
        this.dataForm = dataForm;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DataForm getDataForm() {
        return this.dataForm;
    }

    public Jid getJid() {
        return this.dataForm.findValueAsJid(JID);
    }

    public String getRoomNick() {
        return this.dataForm.findValue(ROOM_NICK);
    }

    public Role getRole() {
        String value = this.dataForm.findValue(ROLE);
        if (value != null) {
            return Role.valueOf(value.toUpperCase());
        }
        return null;
    }

    public boolean isRequestAllowed() {
        return this.dataForm.findValueAsBoolean(REQUEST_ALLOW);
    }

    public static final class Builder
    extends DataForm.Builder<Builder> {
        private Role role;
        private Jid jid;
        private String roomNick;
        private Boolean allowRequest;

        private Builder() {
        }

        public Builder role(Role role) {
            this.role = role;
            return this;
        }

        public Builder jid(Jid jid) {
            this.jid = jid;
            return this;
        }

        public Builder roomNick(String roomNick) {
            this.roomNick = roomNick;
            return this;
        }

        public Builder allowRequest(boolean allowRequest) {
            this.allowRequest = allowRequest;
            return this;
        }

        protected Builder self() {
            return this;
        }

        public RequestVoice build() {
            ArrayList<DataForm.Field> fields = new ArrayList<DataForm.Field>();
            if (this.role != null) {
                fields.add(DataForm.Field.builder().var(RequestVoice.ROLE).value(this.role.name().toLowerCase()).build());
            }
            if (this.jid != null) {
                fields.add(DataForm.Field.builder().var(RequestVoice.JID).value(this.jid).build());
            }
            if (this.roomNick != null) {
                fields.add(DataForm.Field.builder().var(RequestVoice.ROOM_NICK).value(this.roomNick).build());
            }
            if (this.allowRequest != null) {
                fields.add(DataForm.Field.builder().var(RequestVoice.REQUEST_ALLOW).value(this.allowRequest.booleanValue()).build());
            }
            ((Builder)((Builder)this.fields(fields)).formType(RequestVoice.FORM_TYPE)).type(DataForm.Type.SUBMIT);
            return new RequestVoice(new DataForm((DataForm.Builder)this));
        }
    }
}

