/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import rocks.xmpp.core.Jid;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.muc.model.Role;

public final class RoomConfiguration {
    private static final String FORM_TYPE = "http://jabber.org/protocol/muc#roomconfig";
    private static final String MAX_HISTORY_FETCH = "muc#maxhistoryfetch";
    private static final String ALLOW_PM = "muc#roomconfig_allowpm";
    private static final String ALLOW_INVITES = "muc#roomconfig_allowinvites";
    private static final String CHANGE_SUBJECT = "muc#roomconfig_changesubject";
    private static final String ENABLE_LOGGING = "muc#roomconfig_enablelogging";
    private static final String GET_MEMBER_LIST = "muc#roomconfig_getmemberlist";
    private static final String LANGUAGE = "muc#roomconfig_lang";
    private static final String PUBSUB = "muc#roomconfig_pubsub";
    private static final String MAX_USERS = "muc#roomconfig_maxusers";
    private static final String MEMBERS_ONLY = "muc#roomconfig_membersonly";
    private static final String MODERATED_ROOM = "muc#roomconfig_moderatedroom";
    private static final String PASSWORD_PROTECTED = "muc#roomconfig_passwordprotectedroom";
    private static final String PERSISTENT_ROOM = "muc#roomconfig_persistentroom";
    private static final String PRESENCE_BROADCAST = "muc#roomconfig_presencebroadcast";
    private static final String PUBLIC_ROOM = "muc#roomconfig_publicroom";
    private static final String ROOM_ADMINS = "muc#roomconfig_roomadmins";
    private static final String ROOM_DESC = "muc#roomconfig_roomdesc";
    private static final String ROOM_NAME = "muc#roomconfig_roomname";
    private static final String ROOM_OWNERS = "muc#roomconfig_roomowners";
    private static final String ROOM_SECRET = "muc#roomconfig_roomsecret";
    private static final String WHOIS = "muc#roomconfig_whois";
    private final DataForm dataForm;

    public RoomConfiguration(DataForm dataForm) {
        this.dataForm = dataForm;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static String rolesToValue(Collection<Role> roles) {
        if (roles.contains((Object)Role.MODERATOR) && roles.contains((Object)Role.PARTICIPANT)) {
            return "anyone";
        }
        if (roles.contains((Object)Role.PARTICIPANT)) {
            return "participants";
        }
        if (roles.contains((Object)Role.MODERATOR)) {
            return "moderators";
        }
        return "none";
    }

    private static Set<Role> valueToRoles(String value) {
        LinkedHashSet<Role> roles = new LinkedHashSet<Role>();
        if (value != null) {
            switch (value) {
                case "anyone": {
                    roles.add(Role.MODERATOR);
                    roles.add(Role.PARTICIPANT);
                    break;
                }
                case "participants": {
                    roles.add(Role.PARTICIPANT);
                    break;
                }
                case "moderators": {
                    roles.add(Role.MODERATOR);
                    break;
                }
                default: {
                    roles.add(Role.NONE);
                }
            }
        }
        return Collections.unmodifiableSet(roles);
    }

    private static Set<Role> valuesToRoles(Collection<String> values) {
        LinkedHashSet<Role> roles = new LinkedHashSet<Role>();
        for (String value : values) {
            roles.add(Role.valueOf(value.toUpperCase()));
        }
        return Collections.unmodifiableSet(roles);
    }

    public Integer getMaxHistoryMessages() {
        return this.dataForm.findValueAsInteger(MAX_HISTORY_FETCH);
    }

    public Collection<Role> getRolesThatMaySendPrivateMessages() {
        return RoomConfiguration.valueToRoles(this.dataForm.findValue(ALLOW_PM));
    }

    public boolean isInvitesAllowed() {
        return this.dataForm.findValueAsBoolean(ALLOW_INVITES);
    }

    public boolean isChangeSubjectAllowed() {
        return this.dataForm.findValueAsBoolean(CHANGE_SUBJECT);
    }

    public boolean isLoggingEnabled() {
        return this.dataForm.findValueAsBoolean(ENABLE_LOGGING);
    }

    public Collection<Role> getRolesThatMayRetrieveMemberList() {
        return RoomConfiguration.valuesToRoles(this.dataForm.findValues(GET_MEMBER_LIST));
    }

    public String getLanguage() {
        return this.dataForm.findValue(LANGUAGE);
    }

    public URI getPubSubNode() {
        String value = this.dataForm.findValue(PUBSUB);
        if (value != null) {
            try {
                return URI.create(value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public Integer getMaxUsers() {
        return this.dataForm.findValueAsInteger(MAX_USERS);
    }

    public boolean isMembersOnly() {
        return this.dataForm.findValueAsBoolean(MEMBERS_ONLY);
    }

    public boolean isModerated() {
        return this.dataForm.findValueAsBoolean(MODERATED_ROOM);
    }

    public boolean isPasswordProtected() {
        return this.dataForm.findValueAsBoolean(PASSWORD_PROTECTED);
    }

    public boolean isPersistent() {
        return this.dataForm.findValueAsBoolean(PERSISTENT_ROOM);
    }

    public Collection<Role> getRolesForWhichPresenceIsBroadcast() {
        return RoomConfiguration.valuesToRoles(this.dataForm.findValues(PRESENCE_BROADCAST));
    }

    public boolean isPublicRoom() {
        return this.dataForm.findValueAsBoolean(PUBLIC_ROOM);
    }

    public Collection<Jid> getAdministrators() {
        return this.dataForm.findValuesAsJid(ROOM_ADMINS);
    }

    public String getDescription() {
        return this.dataForm.findValue(ROOM_DESC);
    }

    public String getName() {
        return this.dataForm.findValue(ROOM_NAME);
    }

    public Collection<Jid> getOwners() {
        return this.dataForm.findValuesAsJid(ROOM_OWNERS);
    }

    public String getPassword() {
        return this.dataForm.findValue(ROOM_SECRET);
    }

    public Collection<Role> getRolesThatMayDiscoverRealJids() {
        return RoomConfiguration.valueToRoles(this.dataForm.findValue(WHOIS));
    }

    public DataForm getDataForm() {
        return this.dataForm;
    }

    public static final class Builder
    extends DataForm.Builder<Builder> {
        private Integer maxHistoryFetch;
        private Collection<Role> rolesThatMaySendPrivateMessages;
        private Boolean invitesAllowed;
        private Boolean changeSubjectAllowed;
        private Boolean loggingEnabled;
        private Collection<Role> rolesThatMayRetrieveMemberList;
        private String language;
        private URI pubsubNode;
        private Integer maxUsers;
        private Boolean membersOnly;
        private Boolean moderated;
        private Boolean passwordProtected;
        private Boolean persistent;
        private Collection<Role> presenceBroadcast;
        private Boolean publicRoom;
        private Collection<Jid> admins;
        private String description;
        private String name;
        private Collection<Jid> owners;
        private String password;
        private Collection<Role> whois;

        private Builder() {
        }

        public Builder maxHistoryMessages(int maxHistoryMessages) {
            this.maxHistoryFetch = maxHistoryMessages;
            return this;
        }

        public Builder rolesThatMaySendPrivateMessages(Collection<Role> rolesThatMaySendPrivateMessages) {
            this.rolesThatMaySendPrivateMessages = rolesThatMaySendPrivateMessages;
            return this;
        }

        public Builder invitesAllowed(boolean invitesAllowed) {
            this.invitesAllowed = invitesAllowed;
            return this;
        }

        public Builder changeSubjectAllowed(boolean changeSubjectAllowed) {
            this.changeSubjectAllowed = changeSubjectAllowed;
            return this;
        }

        public Builder loggingEnabled(boolean loggingEnabled) {
            this.loggingEnabled = loggingEnabled;
            return this;
        }

        public Builder rolesThatMayRetrieveMemberList(Collection<Role> rolesThatMayRetrieveMemberList) {
            this.rolesThatMayRetrieveMemberList = rolesThatMayRetrieveMemberList;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder pubSubNode(URI pubsubNode) {
            this.pubsubNode = pubsubNode;
            return this;
        }

        public Builder maxUsers(int maxUsers) {
            this.maxUsers = maxUsers;
            return this;
        }

        public Builder membersOnly(boolean membersOnly) {
            this.membersOnly = membersOnly;
            return this;
        }

        public Builder moderated(boolean moderated) {
            this.moderated = moderated;
            return this;
        }

        public Builder passwordProtected(boolean passwordProtected) {
            this.passwordProtected = passwordProtected;
            return this;
        }

        public Builder persistent(boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public Builder rolesForWhichPresenceIsBroadcast(Collection<Role> roles) {
            this.presenceBroadcast = roles;
            return this;
        }

        public Builder publicRoom(boolean publicRoom) {
            this.publicRoom = publicRoom;
            return this;
        }

        public Builder administrators(Collection<Jid> admins) {
            this.admins = admins;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder owners(Collection<Jid> owners) {
            this.owners = owners;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder rolesThatMayDiscoverRealJids(Collection<Role> roles) {
            this.whois = roles;
            return this;
        }

        protected Builder self() {
            return this;
        }

        public RoomConfiguration build() {
            ArrayList<DataForm.Field> fields = new ArrayList<DataForm.Field>();
            if (this.maxHistoryFetch != null) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.MAX_HISTORY_FETCH).value(this.maxHistoryFetch.intValue()).build());
            }
            if (this.rolesThatMaySendPrivateMessages != null && !this.rolesThatMaySendPrivateMessages.isEmpty()) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.ALLOW_PM).value(RoomConfiguration.rolesToValue(this.rolesThatMaySendPrivateMessages)).type(DataForm.Field.Type.LIST_SINGLE).build());
            }
            if (this.invitesAllowed != null) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.ALLOW_INVITES).value(this.invitesAllowed.booleanValue()).build());
            }
            if (this.changeSubjectAllowed != null) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.CHANGE_SUBJECT).value(this.changeSubjectAllowed.booleanValue()).build());
            }
            if (this.loggingEnabled != null) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.ENABLE_LOGGING).value(this.loggingEnabled.booleanValue()).build());
            }
            if (this.rolesThatMayRetrieveMemberList != null && !this.rolesThatMayRetrieveMemberList.isEmpty()) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.GET_MEMBER_LIST).valuesEnum(this.rolesThatMayRetrieveMemberList).type(DataForm.Field.Type.LIST_MULTI).build());
            }
            if (this.language != null) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.LANGUAGE).value(this.language).build());
            }
            if (this.pubsubNode != null) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.PUBSUB).value(this.pubsubNode.toString()).build());
            }
            if (this.maxUsers != null) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.MAX_USERS).value(this.maxUsers.intValue()).type(DataForm.Field.Type.LIST_SINGLE).build());
            }
            if (this.membersOnly != null) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.MEMBERS_ONLY).value(this.membersOnly.booleanValue()).build());
            }
            if (this.moderated != null) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.MODERATED_ROOM).value(this.moderated.booleanValue()).build());
            }
            if (this.passwordProtected != null) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.PASSWORD_PROTECTED).value(this.passwordProtected.booleanValue()).build());
            }
            if (this.persistent != null) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.PERSISTENT_ROOM).value(this.persistent.booleanValue()).build());
            }
            if (this.presenceBroadcast != null) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.PRESENCE_BROADCAST).valuesEnum(this.presenceBroadcast).type(DataForm.Field.Type.LIST_MULTI).build());
            }
            if (this.publicRoom != null) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.PUBLIC_ROOM).value(this.publicRoom.booleanValue()).build());
            }
            if (this.admins != null && !this.admins.isEmpty()) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.ROOM_ADMINS).valuesJid(this.admins).build());
            }
            if (this.description != null) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.ROOM_DESC).value(this.description).build());
            }
            if (this.name != null) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.ROOM_NAME).value(this.name).build());
            }
            if (this.owners != null && !this.owners.isEmpty()) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.ROOM_OWNERS).valuesJid(this.owners).build());
            }
            if (this.password != null) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.ROOM_SECRET).value(this.password).build());
            }
            if (this.whois != null && !this.whois.isEmpty()) {
                fields.add(DataForm.Field.builder().var(RoomConfiguration.WHOIS).value(RoomConfiguration.rolesToValue(this.whois)).type(DataForm.Field.Type.LIST_SINGLE).build());
            }
            ((Builder)((Builder)this.fields(fields)).formType(RoomConfiguration.FORM_TYPE)).type(DataForm.Type.SUBMIT);
            return new RoomConfiguration(new DataForm((DataForm.Builder)this));
        }
    }
}

