/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.offline.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="offline")
public final class OfflineMessage {
    public static final String NAMESPACE = "http://jabber.org/protocol/offline";
    @XmlElement(name="item")
    private final List<Item> items = new ArrayList<Item>();
    @XmlElement(name="fetch")
    private final String fetch;
    @XmlElement(name="purge")
    private final String purge;

    private OfflineMessage() {
        this.fetch = null;
        this.purge = null;
    }

    public OfflineMessage(Item ... item) {
        this(Arrays.asList(item));
    }

    public OfflineMessage(Collection<Item> items) {
        if (items.isEmpty()) {
            throw new IllegalArgumentException("items must not be empty");
        }
        this.items.addAll(items);
        this.fetch = null;
        this.purge = null;
    }

    public OfflineMessage(boolean fetch, boolean purge) {
        this.fetch = fetch ? "" : null;
        this.purge = purge ? "" : null;
    }

    public String getId() {
        if (!this.items.isEmpty()) {
            return this.items.get(0).getId();
        }
        return null;
    }

    public List<Item> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public static final class Item {
        @XmlAttribute(name="node")
        private final String id;
        @XmlAttribute(name="action")
        private final Action action;

        private Item() {
            this.id = null;
            this.action = null;
        }

        public Item(String id, Action action) {
            this.id = Objects.requireNonNull(id);
            this.action = action;
        }

        public final String getId() {
            return this.id;
        }

        @XmlEnum
        public static enum Action {
            REMOVE,
            VIEW;

        }
    }
}

