/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.privacy.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import rocks.xmpp.core.Jid;
import rocks.xmpp.extensions.privacy.model.PrivacyRule;

public final class PrivacyList
implements Comparable<PrivacyList> {
    @XmlElement(name="item")
    private final List<PrivacyRule> items = new ArrayList<PrivacyRule>();
    @XmlAttribute(name="name")
    private final String name;
    @XmlTransient
    private boolean isActive;
    @XmlTransient
    private boolean isDefault;

    private PrivacyList() {
        this.name = null;
    }

    public PrivacyList(String name, Collection<PrivacyRule> items) {
        this.name = Objects.requireNonNull(name);
        if (items != null) {
            this.items.addAll(items);
        }
    }

    public PrivacyList(String name) {
        this.name = name;
    }

    public static PrivacyList createInvisibilityList() {
        return PrivacyList.createInvisibilityListExceptForUsers("invisible", new Jid[0]);
    }

    public static PrivacyList createInvisibilityListExceptForUsers(String listName, Jid ... jids) {
        ArrayList<PrivacyRule> rules = new ArrayList<PrivacyRule>();
        long order = 1L;
        for (Jid jid : jids) {
            rules.add(new PrivacyRule(PrivacyRule.Action.ALLOW, order++, jid).filterPresenceOut());
        }
        rules.add(new PrivacyRule(PrivacyRule.Action.DENY, order).filterPresenceOut());
        return new PrivacyList(listName, rules);
    }

    public static PrivacyList createInvisibilityListExceptForGroups(String listName, String ... groups) {
        ArrayList<PrivacyRule> rules = new ArrayList<PrivacyRule>();
        long order = 1L;
        for (String group : groups) {
            rules.add(new PrivacyRule(PrivacyRule.Action.ALLOW, order++, group).filterPresenceOut());
        }
        rules.add(new PrivacyRule(PrivacyRule.Action.DENY, order).filterPresenceOut());
        return new PrivacyList(listName, rules);
    }

    public static PrivacyList createInvisibilityListForUsers(String listName, Jid ... jids) {
        ArrayList<PrivacyRule> rules = new ArrayList<PrivacyRule>();
        long order = 1L;
        for (Jid jid : jids) {
            rules.add(new PrivacyRule(PrivacyRule.Action.DENY, order++, jid).filterPresenceOut());
        }
        rules.add(new PrivacyRule(PrivacyRule.Action.ALLOW, order).filterPresenceOut());
        return new PrivacyList(listName, rules);
    }

    public static PrivacyList createInvisibilityListForGroups(String listName, String ... groups) {
        ArrayList<PrivacyRule> rules = new ArrayList<PrivacyRule>();
        long order = 1L;
        for (String group : groups) {
            rules.add(new PrivacyRule(PrivacyRule.Action.DENY, order++, group).filterPresenceOut());
        }
        rules.add(new PrivacyRule(PrivacyRule.Action.ALLOW, order).filterPresenceOut());
        return new PrivacyList(listName, rules);
    }

    public final List<PrivacyRule> getPrivacyRules() {
        return Collections.unmodifiableList(this.items);
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isDefault() {
        return this.isDefault;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    public final PrivacyList asActive() {
        PrivacyList privacyList = new PrivacyList(this.name, this.items);
        privacyList.isActive = true;
        return privacyList;
    }

    public final PrivacyList asDefault() {
        PrivacyList privacyList = new PrivacyList(this.name, this.items);
        privacyList.isDefault = true;
        return privacyList;
    }

    @Override
    public final int compareTo(PrivacyList o) {
        if (this == o) {
            return 0;
        }
        if (o != null) {
            if (this.isDefault) {
                if (o.isDefault) {
                    return this.name != null ? this.name.compareTo(o.name) : 1;
                }
                return -1;
            }
            if (this.isActive) {
                if (o.isDefault) {
                    return 1;
                }
                if (o.isActive) {
                    return this.name != null ? this.name.compareTo(o.name) : 1;
                }
                return -1;
            }
            if (o.isDefault || o.isActive) {
                return 1;
            }
            return this.name != null ? this.name.compareTo(o.name) : 1;
        }
        return -1;
    }

    public final String toString() {
        return this.name;
    }
}

