/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.privacy.model;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.roster.model.Contact;

public final class PrivacyRule
implements Comparable<PrivacyRule> {
    @XmlAttribute(name="type")
    private final Type type;
    @XmlAttribute(name="value")
    private final String value;
    @XmlAttribute(name="action")
    private final Action action;
    @XmlAttribute(name="order")
    private final long order;
    @XmlElement(name="message")
    private final String message;
    @XmlElement(name="presence-in")
    private final String presenceIn;
    @XmlElement(name="presence-out")
    private final String presenceOut;
    @XmlElement(name="iq")
    private final String iq;

    private PrivacyRule() {
        this.action = null;
        this.order = 0L;
        this.type = null;
        this.value = null;
        this.message = null;
        this.presenceIn = null;
        this.presenceOut = null;
        this.iq = null;
    }

    public PrivacyRule(Action action, long order) {
        this(action, order, null, null, false, false, false, false);
    }

    private PrivacyRule(Action action, long order, Type type, String value, boolean filterMessage, boolean filterPresenceIn, boolean filterPresenceOut, boolean filterIQ) {
        if (order < 0L) {
            throw new IllegalArgumentException("order must be greater 0.");
        }
        this.action = Objects.requireNonNull(action);
        this.order = order;
        this.type = type;
        this.value = value;
        this.message = filterMessage ? "" : null;
        this.presenceIn = filterPresenceIn ? "" : null;
        this.presenceOut = filterPresenceOut ? "" : null;
        this.iq = filterIQ ? "" : null;
    }

    public PrivacyRule(Action action, long order, Contact.Subscription subscription) {
        if (Contact.Subscription.REMOVE.equals((Object)subscription)) {
            throw new IllegalArgumentException("subscription must not be 'remove'");
        }
        this.action = action;
        this.order = order;
        this.type = Type.SUBSCRIPTION;
        this.value = subscription.name().toLowerCase();
        this.message = null;
        this.presenceIn = null;
        this.presenceOut = null;
        this.iq = null;
    }

    public PrivacyRule(Action action, long order, Jid jid) {
        this(action, order, Type.JID, jid.toEscapedString(), false, false, false, false);
    }

    public PrivacyRule(Action action, long order, String group) {
        this(action, order, Type.GROUP, group, false, false, false, false);
    }

    public final Type getType() {
        return this.type;
    }

    public final Action getAction() {
        return this.action;
    }

    public final String getValue() {
        return this.value;
    }

    public final long getOrder() {
        return this.order;
    }

    public final boolean isFilterMessage() {
        return this.message != null || this.isFilterEverything();
    }

    public final PrivacyRule filterMessage() {
        return new PrivacyRule(this.action, this.order, this.type, this.value, true, this.presenceIn != null, this.presenceOut != null, this.iq != null);
    }

    public final boolean isFilterIQ() {
        return this.iq != null || this.isFilterEverything();
    }

    public final PrivacyRule filterIQ() {
        return new PrivacyRule(this.action, this.order, this.type, this.value, this.message != null, this.presenceIn != null, this.presenceOut != null, true);
    }

    public final boolean isFilterPresenceIn() {
        return this.presenceIn != null || this.isFilterEverything();
    }

    public final PrivacyRule filterPresenceIn() {
        return new PrivacyRule(this.action, this.order, this.type, this.value, this.message != null, true, this.presenceOut != null, this.iq != null);
    }

    public final boolean isFilterPresenceOut() {
        return this.presenceOut != null || this.isFilterEverything();
    }

    public final PrivacyRule filterPresenceOut() {
        return new PrivacyRule(this.action, this.order, this.type, this.value, this.message != null, this.presenceIn != null, true, this.iq != null);
    }

    private boolean isFilterEverything() {
        return this.presenceIn == null && this.presenceOut == null && this.message == null && this.iq == null;
    }

    @Override
    public final int compareTo(PrivacyRule o) {
        if (this == o) {
            return 0;
        }
        return o != null ? Long.compare(this.order, o.order) : -1;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.action.name().toLowerCase());
        sb.append(", ");
        sb.append(this.order);
        if (this.type != null) {
            sb.append(", ");
            sb.append(this.type.name().toLowerCase());
        }
        if (this.value != null) {
            sb.append(", ");
            sb.append(this.value);
        }
        return sb.toString();
    }

    public static enum Action {
        ALLOW,
        DENY;

    }

    public static enum Type {
        GROUP,
        JID,
        SUBSCRIPTION;

    }
}

