/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import rocks.xmpp.core.stanza.model.AbstractPresence;
import rocks.xmpp.extensions.data.model.DataForm;

public final class SubscribeOptions {
    private static final String FORM_TYPE = "http://jabber.org/protocol/pubsub#subscribe_options";
    private static final String DELIVER = "pubsub#deliver";
    private static final String DIGEST = "pubsub#digest";
    private static final String DIGEST_FREQUENCY = "pubsub#digest_frequency";
    private static final String EXPIRE = "pubsub#expire";
    private static final String INCLUDE_BODY = "pubsub#include_body";
    private static final String SHOW_VALUES = "pubsub#show-values";
    private static final String SUBSCRIPTION_TYPE = "pubsub#subscription_type";
    private static final String SUBSCRIPTION_DEPTH = "pubsub#subscription_depth";
    private final DataForm dataForm;

    public SubscribeOptions(DataForm dataForm) {
        this.dataForm = dataForm;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DataForm getDataForm() {
        return this.dataForm;
    }

    public Boolean isDeliver() {
        return this.dataForm.findValueAsBoolean(DELIVER);
    }

    public Boolean isDigest() {
        return this.dataForm.findValueAsBoolean(DIGEST);
    }

    public Integer getDigestFrequency() {
        return this.dataForm.findValueAsInteger(DIGEST_FREQUENCY);
    }

    public Date getExpire() {
        DataForm.Field field = this.dataForm.findField(EXPIRE);
        if (!field.getValues().isEmpty() && field.getValues().get(0) != null && !((String)field.getValues().get(0)).equals("presence")) {
            return field.getValueAsDate();
        }
        return null;
    }

    public Boolean isIncludeBody() {
        return this.dataForm.findValueAsBoolean(INCLUDE_BODY);
    }

    public List<AbstractPresence.Show> getShowValues() {
        List values = this.dataForm.findValues(SHOW_VALUES);
        ArrayList<AbstractPresence.Show> list = new ArrayList<AbstractPresence.Show>();
        for (String value : values) {
            if ("online".equals(value)) {
                list.add(null);
                continue;
            }
            list.add(AbstractPresence.Show.valueOf((String)value.toUpperCase()));
        }
        return list;
    }

    public SubscriptionType getSubscriptionType() {
        String value = this.dataForm.findValue(SUBSCRIPTION_TYPE);
        if (value != null) {
            return SubscriptionType.valueOf(value.toUpperCase());
        }
        return null;
    }

    public Integer getSubscriptionDepth() {
        String value = this.dataForm.findValue(SUBSCRIPTION_DEPTH);
        if ("all".equals(value)) {
            return -1;
        }
        return Integer.valueOf(value);
    }

    public boolean isTemporary() {
        DataForm.Field field = this.dataForm.findField(EXPIRE);
        return !field.getValues().isEmpty() && field.getValues().get(0) != null && ((String)field.getValues().get(0)).equals("presence");
    }

    public static final class Builder
    extends DataForm.Builder<Builder> {
        private Boolean deliver;
        private Boolean digest;
        private Integer digestFrequency;
        private Boolean includeBody;
        private Collection<AbstractPresence.Show> showValues;
        private Date expireAt;
        private Boolean temporary;
        private SubscriptionType subscriptionType;
        private Integer subscriptionDepth;

        private Builder() {
        }

        public Builder deliver(boolean deliver) {
            this.deliver = deliver;
            return this;
        }

        public Builder digest(boolean digest) {
            this.digest = digest;
            return this;
        }

        public Builder digestFrequency(int digestFrequency) {
            this.digestFrequency = digestFrequency;
            return this;
        }

        public Builder includeBody(boolean includeBody) {
            this.includeBody = includeBody;
            return this;
        }

        public Builder showValues(Collection<AbstractPresence.Show> showValues) {
            this.showValues = showValues;
            return this;
        }

        public Builder expireAt(Date expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        public Builder temporary(boolean temporary) {
            this.temporary = temporary;
            return this;
        }

        public Builder subscriptionType(SubscriptionType subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        public Builder subscriptionDepth(int subscriptionDepth) {
            this.subscriptionDepth = subscriptionDepth;
            return this;
        }

        protected Builder self() {
            return this;
        }

        public SubscribeOptions build() {
            DataForm.Field.Builder fieldBuilder;
            ArrayList<DataForm.Field> fields = new ArrayList<DataForm.Field>();
            if (this.deliver != null) {
                fields.add(DataForm.Field.builder().var(SubscribeOptions.DELIVER).value(this.deliver.booleanValue()).build());
            }
            if (this.digest != null) {
                fields.add(DataForm.Field.builder().var(SubscribeOptions.DIGEST).value(this.digest.booleanValue()).build());
            }
            if (this.digestFrequency != null) {
                fields.add(DataForm.Field.builder().var(SubscribeOptions.DIGEST_FREQUENCY).value(this.digestFrequency.intValue()).build());
            }
            if (this.temporary != null && this.temporary.booleanValue()) {
                fields.add(DataForm.Field.builder().var(SubscribeOptions.EXPIRE).value("presence").build());
            } else if (this.expireAt != null) {
                fields.add(DataForm.Field.builder().var(SubscribeOptions.EXPIRE).value(this.expireAt).build());
            }
            if (this.includeBody != null) {
                fields.add(DataForm.Field.builder().var(SubscribeOptions.INCLUDE_BODY).value(this.includeBody.booleanValue()).build());
            }
            if (this.showValues != null && !this.showValues.isEmpty()) {
                fieldBuilder = DataForm.Field.builder().var(SubscribeOptions.SHOW_VALUES);
                ArrayList<String> values = new ArrayList<String>();
                for (AbstractPresence.Show show : this.showValues) {
                    if (show != null) {
                        values.add(show.name().toLowerCase());
                        continue;
                    }
                    values.add("online");
                }
                fieldBuilder.values(values).type(DataForm.Field.Type.LIST_MULTI);
                fields.add(fieldBuilder.build());
            }
            if (this.subscriptionType != null) {
                fields.add(DataForm.Field.builder().var(SubscribeOptions.SUBSCRIPTION_TYPE).value(this.subscriptionType.name().toLowerCase()).type(DataForm.Field.Type.LIST_SINGLE).build());
            }
            if (this.subscriptionDepth != null) {
                fieldBuilder = DataForm.Field.builder().var(SubscribeOptions.SUBSCRIPTION_DEPTH);
                if (this.subscriptionDepth < 1) {
                    fieldBuilder.value("all");
                } else {
                    fieldBuilder.value(this.subscriptionDepth.toString());
                }
                fieldBuilder.type(DataForm.Field.Type.LIST_SINGLE);
                fields.add(fieldBuilder.build());
            }
            ((Builder)((Builder)this.fields(fields)).formType(SubscribeOptions.FORM_TYPE)).type(DataForm.Type.SUBMIT);
            return new SubscribeOptions(new DataForm((DataForm.Builder)this));
        }
    }

    public static enum SubscriptionType {
        ITEMS,
        NODES;

    }
}

