/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub.model.event;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.core.Jid;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.pubsub.model.Item;
import rocks.xmpp.extensions.pubsub.model.Subscription;
import rocks.xmpp.extensions.pubsub.model.SubscriptionState;

@XmlRootElement(name="event")
public final class Event {
    @XmlElements(value={@XmlElement(name="configuration", type=Configuration.class), @XmlElement(name="delete", type=Delete.class), @XmlElement(name="items", type=Items.class), @XmlElement(name="purge", type=Purge.class), @XmlElement(name="subscription", type=SubscriptionInfo.class)})
    private PubSubEventChildElement type;

    private Event() {
    }

    private Event(PubSubEventChildElement type) {
        this.type = type;
    }

    public String getNode() {
        return this.type != null ? this.type.getNode() : null;
    }

    public boolean isConfiguration() {
        return this.type instanceof Configuration;
    }

    public boolean isDelete() {
        return this.type instanceof Delete;
    }

    public boolean isPurge() {
        return this.type instanceof Purge;
    }

    public Subscription getSubscription() {
        if (this.type instanceof SubscriptionInfo) {
            return (SubscriptionInfo)this.type;
        }
        return null;
    }

    public List<Item> getItems() {
        if (this.type instanceof Items) {
            return Collections.unmodifiableList(((Items)this.type).getItems());
        }
        return Collections.emptyList();
    }

    public DataForm getConfigurationForm() {
        if (this.type instanceof Configuration) {
            return ((Configuration)this.type).getConfigurationForm();
        }
        return null;
    }

    public URI getRedirectUri() {
        if (this.type instanceof Delete && ((Delete)this.type).getRedirect() != null) {
            return ((Delete)this.type).getRedirect().getUri();
        }
        return null;
    }

    private static abstract class PubSubEventChildElement {
        @XmlAttribute(name="node")
        private String node;

        private PubSubEventChildElement() {
        }

        private PubSubEventChildElement(String node) {
            this.node = node;
        }

        public String getNode() {
            return this.node;
        }
    }

    private static final class ItemElement
    implements Item {
        @XmlAnyElement(lax=true)
        private Object object;
        @XmlAttribute(name="id")
        private String id;
        @XmlAttribute(name="node")
        private String node;
        @XmlAttribute(name="publisher")
        private String publisher;

        private ItemElement() {
        }

        private ItemElement(String id) {
            this.id = id;
        }

        private ItemElement(Object object) {
            this.object = object;
        }

        @Override
        public Object getPayload() {
            return this.object;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getNode() {
            return this.node;
        }

        @Override
        public String getPublisher() {
            return this.publisher;
        }
    }

    private static final class SubscriptionInfo
    extends PubSubEventChildElement
    implements Subscription {
        @XmlAttribute(name="expiry")
        private Date expiry;
        @XmlAttribute(name="jid")
        private Jid jid;
        @XmlAttribute(name="subid")
        private String subid;
        @XmlAttribute(name="subscription")
        private SubscriptionState subscriptionState;

        private SubscriptionInfo() {
        }

        @Override
        public Jid getJid() {
            return this.jid;
        }

        @Override
        public String getSubId() {
            return this.subid;
        }

        @Override
        public SubscriptionState getSubscriptionState() {
            return this.subscriptionState;
        }

        @Override
        public Date getExpiry() {
            return this.expiry;
        }

        @Override
        public boolean isConfigurationRequired() {
            return false;
        }

        @Override
        public boolean isConfigurationSupported() {
            return false;
        }
    }

    private static final class Retract {
        @XmlAttribute(name="node")
        private String node;
        @XmlAttribute(name="notify")
        private Boolean notify;
        @XmlElement
        private ItemElement item;
        @XmlAttribute
        private String id;

        private Retract() {
        }

        private Retract(String node, ItemElement item, Boolean notify) {
            this.node = node;
            this.item = item;
            this.notify = notify;
        }

        private String getId() {
            return this.id;
        }
    }

    private static final class Purge
    extends PubSubEventChildElement {
        private Purge() {
        }

        private Purge(String node) {
            super(node);
        }
    }

    private static final class Items
    extends PubSubEventChildElement {
        @XmlElement(name="item")
        private final List<ItemElement> items = new ArrayList<ItemElement>();
        @XmlAttribute(name="max_items")
        private Long maxItems;
        @XmlAttribute(name="subid")
        private String subid;
        @XmlElement(name="retract")
        private Retract retract;

        private Items() {
        }

        private Items(String node) {
            super(node);
        }

        private Items(String node, long maxItems) {
            super(node);
            this.maxItems = maxItems;
        }

        private Items(String node, ItemElement item) {
            super(node);
            this.items.add(item);
        }

        private List<? extends Item> getItems() {
            return this.items;
        }

        private Retract getRetract() {
            return this.retract;
        }
    }

    private static final class Delete
    extends PubSubEventChildElement {
        @XmlElement(name="redirect")
        private Redirect redirect;

        private Delete() {
        }

        private Delete(String node) {
            super(node);
        }

        private Delete(String node, Redirect redirect) {
            super(node);
            this.redirect = redirect;
        }

        private Redirect getRedirect() {
            return this.redirect;
        }

        private static final class Redirect {
            @XmlAttribute(name="uri")
            private URI uri;

            private Redirect() {
            }

            private Redirect(URI uri) {
                this.uri = uri;
            }

            private URI getUri() {
                return this.uri;
            }
        }
    }

    private static final class Configuration
    extends PubSubEventChildElement {
        @XmlElementRef
        private DataForm dataForm;

        private Configuration() {
        }

        private DataForm getConfigurationForm() {
            return this.dataForm;
        }
    }
}

