/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.reach.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlValue;

public final class Address {
    @XmlElement(name="desc")
    private final List<Description> descriptions = new ArrayList<Description>();
    @XmlAttribute
    private final URI uri;

    private Address() {
        this.uri = null;
    }

    public Address(URI uri) {
        this.uri = Objects.requireNonNull(uri);
    }

    public Address(URI uri, Description ... descriptions) {
        this.uri = Objects.requireNonNull(uri);
        this.descriptions.addAll(Arrays.asList(descriptions));
    }

    public final URI getUri() {
        return this.uri;
    }

    public final List<Description> getDescriptions() {
        return Collections.unmodifiableList(this.descriptions);
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address other = (Address)o;
        return Objects.equals(this.descriptions, other.descriptions) && Objects.equals(this.uri, other.uri);
    }

    public final int hashCode() {
        return Objects.hash(this.descriptions, this.uri);
    }

    public final String toString() {
        return this.uri != null ? this.uri.toString() : super.toString();
    }

    public static final class Description {
        @XmlValue
        private final String value;
        @XmlAttribute(name="lang", namespace="http://www.w3.org/XML/1998/namespace")
        private final String language;

        private Description() {
            this(null, null);
        }

        public Description(String value, String language) {
            this.value = value;
            this.language = language;
        }

        public final String getValue() {
            return this.value;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Description)) {
                return false;
            }
            Description other = (Description)o;
            return Objects.equals(this.value, other.value) && Objects.equals(this.language, other.language);
        }

        public final int hashCode() {
            return Objects.hash(this.value, this.language);
        }

        public final String toString() {
            return this.value;
        }
    }
}

