/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rpc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import rocks.xmpp.extensions.rpc.model.Parameter;
import rocks.xmpp.extensions.rpc.model.Value;

@XmlRootElement(name="query")
public final class Rpc {
    public static final String NAMESPACE = "jabber:iq:rpc";
    @XmlElement(name="methodCall")
    private MethodCall methodCall;
    @XmlElement(name="methodResponse")
    private MethodResponse methodResponse;

    private Rpc() {
    }

    public Rpc(String methodName, Value ... parameters) {
        this.methodCall = new MethodCall(methodName, parameters);
    }

    public Rpc(Value value) {
        this.methodResponse = new MethodResponse(value);
    }

    public Rpc(MethodResponse.Fault fault) {
        this.methodResponse = new MethodResponse(fault);
    }

    public final MethodCall getMethodCall() {
        return this.methodCall;
    }

    public final MethodResponse getMethodResponse() {
        return this.methodResponse;
    }

    public static final class MethodResponse {
        @XmlElementWrapper(name="params")
        @XmlElement(name="param")
        private final List<Parameter> parameters = new ArrayList<Parameter>();
        @XmlElement(name="fault")
        private Fault fault;

        private MethodResponse() {
        }

        MethodResponse(Value value) {
            this.parameters.add(new Parameter(value));
        }

        MethodResponse(Fault fault) {
            this.fault = fault;
        }

        public final Value getResponse() {
            if (!this.parameters.isEmpty()) {
                return this.parameters.get(0).getValue();
            }
            return null;
        }

        public final Fault getFault() {
            return this.fault;
        }

        public static final class Fault {
            @XmlElement(name="value")
            private Value value;

            private Fault() {
            }

            public Fault(int faultCode, String faultString) {
                LinkedHashMap<String, Value> faultMap = new LinkedHashMap<String, Value>();
                faultMap.put("faultCode", new Value(faultCode));
                faultMap.put("faultString", new Value(faultString));
                this.value = new Value(faultMap);
            }

            public final int getFaultCode() {
                Integer value;
                Map<String, Value> map;
                Value faultCode;
                if (this.value != null && (faultCode = (map = this.value.getAsMap()).get("faultCode")) != null && (value = faultCode.getAsInteger()) != null) {
                    return value;
                }
                return 0;
            }

            public final String getFaultString() {
                Map<String, Value> map;
                Value faultCode;
                if (this.value != null && (faultCode = (map = this.value.getAsMap()).get("faultString")) != null) {
                    return faultCode.getAsString();
                }
                return null;
            }
        }
    }

    @XmlType(propOrder={"methodName", "parameters"})
    public static final class MethodCall {
        @XmlElementWrapper(name="params")
        @XmlElement(name="param")
        private final List<Parameter> parameters = new ArrayList<Parameter>();
        @XmlElement(name="methodName")
        private final String methodName;

        private MethodCall() {
            this.methodName = null;
        }

        MethodCall(String methodName, Value ... parameters) {
            this.methodName = methodName;
            for (Value value : parameters) {
                this.parameters.add(new Parameter(value));
            }
        }

        public final String getMethodName() {
            return this.methodName;
        }

        public final List<Value> getParameters() {
            ArrayList<Value> values = new ArrayList<Value>();
            for (Parameter parameter : this.parameters) {
                values.add(parameter.getValue());
            }
            return Collections.unmodifiableList(values);
        }
    }
}

