/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rpc.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.extensions.rpc.model.ArrayType;
import rocks.xmpp.extensions.rpc.model.NumericBoolean;
import rocks.xmpp.extensions.rpc.model.StructType;

@XmlRootElement(name="value")
public final class Value {
    @XmlElements(value={@XmlElement(name="i4", type=Integer.class), @XmlElement(name="int", type=Integer.class), @XmlElement(name="string", type=String.class), @XmlElement(name="double", type=Double.class), @XmlElement(name="base64", type=byte[].class), @XmlElement(name="boolean", type=NumericBoolean.class), @XmlElement(name="dateTime.iso8601", type=Date.class), @XmlElement(name="array", type=ArrayType.class), @XmlElement(name="struct", type=StructType.class)})
    private final Object value;

    private Value() {
        this.value = null;
    }

    public Value(Integer integer) {
        this.value = integer;
    }

    public Value(String string) {
        this.value = string;
    }

    public Value(Double d) {
        this.value = d;
    }

    public Value(byte[] bytes) {
        this.value = bytes;
    }

    public Value(Boolean b) {
        this.value = new NumericBoolean(b);
    }

    public Value(Date date) {
        this.value = date;
    }

    public Value(List<Value> list) {
        if (list != null) {
            ArrayType arrayType = new ArrayType();
            for (Value value : list) {
                arrayType.values.add(value);
            }
            this.value = arrayType;
        } else {
            this.value = null;
        }
    }

    public Value(Map<String, Value> map) {
        if (map != null) {
            StructType structType = new StructType();
            for (Map.Entry<String, Value> entry : map.entrySet()) {
                structType.values.add(new StructType.MemberType(entry.getKey(), entry.getValue()));
            }
            this.value = structType;
        } else {
            this.value = null;
        }
    }

    public final Integer getAsInteger() {
        return this.value instanceof Integer ? (Integer)this.value : null;
    }

    public final Double getAsDouble() {
        return this.value instanceof Double ? (Double)this.value : null;
    }

    public final String getAsString() {
        return this.value instanceof String ? (String)this.value : null;
    }

    public final byte[] getAsByteArray() {
        return this.value instanceof byte[] ? (byte[])this.value : null;
    }

    public final Boolean getAsBoolean() {
        return this.value instanceof NumericBoolean ? ((NumericBoolean)this.value).getAsBoolean() : null;
    }

    public final Date getAsDate() {
        return this.value instanceof Date ? (Date)this.value : null;
    }

    public final List<Value> getAsArray() {
        if (this.value instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)this.value;
            ArrayList<Value> result = new ArrayList<Value>();
            for (Value value : arrayType.values) {
                result.add(value);
            }
            return result;
        }
        return null;
    }

    public final Map<String, Value> getAsMap() {
        if (this.value instanceof StructType) {
            StructType structType = (StructType)this.value;
            HashMap<String, Value> result = new HashMap<String, Value>();
            for (StructType.MemberType member : structType.values) {
                result.put(member.name, member.value);
            }
            return result;
        }
        return null;
    }
}

