/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.shim.model;

import java.util.Date;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;
import rocks.xmpp.extensions.time.model.EntityTime;

public final class Header {
    @XmlAttribute(name="name")
    private final String name;
    @XmlValue
    private final String value;

    private Header() {
        this.name = null;
        this.value = null;
    }

    public Header(String name, String value) {
        this.name = Objects.requireNonNull(name);
        this.value = value;
    }

    public static Header start(Date date) {
        return new Header("Start", EntityTime.toUtcString(date));
    }

    public static Header stop(Date date) {
        return new Header("Stop", EntityTime.toUtcString(date));
    }

    public final String getName() {
        return this.name;
    }

    public final String getValue() {
        return this.value;
    }

    public final String toString() {
        return this.name + ": " + this.value;
    }
}

