/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.si.profile.filetransfer.model;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.extensions.filetransfer.FileTransferOffer;
import rocks.xmpp.extensions.filetransfer.Range;
import rocks.xmpp.extensions.hashes.model.Hash;

@XmlRootElement(name="file")
public final class SIFileTransferOffer
implements FileTransferOffer {
    public static final String NAMESPACE = "http://jabber.org/protocol/si/profile/file-transfer";
    @XmlAttribute(name="size")
    private final Long size;
    @XmlAttribute(name="name")
    private final String name;
    @XmlAttribute(name="date")
    private final Date date;
    @XmlAttribute(name="hash")
    private final String hash;
    @XmlElement(name="desc")
    private final String description;
    @XmlElement(name="range")
    private final SIRange range;

    private SIFileTransferOffer() {
        this(null, 0L);
    }

    public SIFileTransferOffer(String name, long size) {
        this(name, size, null, null, null, null);
    }

    public SIFileTransferOffer(String name, long size, Date lastModified, String hash, String description, SIRange range) {
        this.name = name;
        this.size = size;
        this.date = lastModified;
        this.hash = hash;
        this.description = description;
        this.range = range;
    }

    @Override
    public final long getSize() {
        return this.size != null ? this.size : 0L;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Date getDate() {
        return this.date;
    }

    @Override
    public final List<Hash> getHashes() {
        if (this.hash != null) {
            return Collections.unmodifiableList(Arrays.asList(new Hash(new BigInteger(this.hash, 16).toByteArray(), "md5")));
        }
        return Collections.emptyList();
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final Range getRange() {
        return this.range;
    }

    public static final class SIRange
    implements Range {
        @XmlAttribute
        private final long offset;
        @XmlAttribute
        private final long length;

        private SIRange() {
            this.length = 0L;
            this.offset = 0L;
        }

        public SIRange(long offset, long length) {
            this.offset = offset;
            this.length = length;
        }

        @Override
        public final long getOffset() {
            return this.offset;
        }

        @Override
        public final long getLength() {
            return this.length;
        }
    }
}

