/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.time.model;

import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.extensions.time.model.TimeZoneAdapter;

@XmlRootElement(name="time")
public final class EntityTime {
    public static final String NAMESPACE = "urn:xmpp:time";
    @XmlJavaTypeAdapter(value=TimeZoneAdapter.class)
    @XmlElement(name="tzo")
    private final TimeZone tzo;
    @XmlJavaTypeAdapter(value=UTCDateAdapter.class)
    @XmlElement(name="utc")
    private final Date utc;

    public EntityTime() {
        this.tzo = null;
        this.utc = null;
    }

    public EntityTime(TimeZone timeZone, Date date) {
        this.tzo = Objects.requireNonNull(timeZone);
        this.utc = Objects.requireNonNull(date);
    }

    public static Date toUtcDate(String v) {
        Calendar calendar = DatatypeConverter.parseDateTime((String)v);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        return calendar.getTime();
    }

    public static String toUtcString(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        return DatatypeConverter.printDateTime((Calendar)calendar);
    }

    public final TimeZone getTimezone() {
        return this.tzo;
    }

    public final Date getDate() {
        return this.utc;
    }

    public final String toString() {
        if (this.utc != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.utc);
            if (this.tzo != null) {
                calendar.setTimeZone(this.tzo);
            }
            return calendar.getTime().toString();
        }
        return super.toString();
    }

    private static final class UTCDateAdapter
    extends XmlAdapter<String, Date> {
        private UTCDateAdapter() {
        }

        public final Date unmarshal(String v) throws Exception {
            return EntityTime.toUtcDate(v);
        }

        public final String marshal(Date v) throws Exception {
            return EntityTime.toUtcString(v);
        }
    }
}

