/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.tune.model;

import java.net.URI;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="tune")
public final class Tune {
    public static final String NAMESPACE = "http://jabber.org/protocol/tune";
    @XmlElement(name="artist")
    private final String artist;
    @XmlElement(name="length")
    private final Integer length;
    @XmlElement(name="rating")
    private final Integer rating;
    @XmlElement(name="source")
    private final String source;
    @XmlElement(name="title")
    private final String title;
    @XmlElement(name="track")
    private final String track;
    @XmlElement(name="uri")
    private final URI uri;

    private Tune() {
        this(null, null);
    }

    public Tune(String artist, String title) {
        this(artist, title, null, null, null, null, null);
    }

    public Tune(String artist, String title, Integer length, Integer rating, String source, String track, URI uri) {
        this.artist = artist;
        this.title = title;
        this.length = length;
        if (rating != null && (rating < 0 || rating > 10)) {
            throw new IllegalArgumentException("rating must not be greater than 10.");
        }
        this.rating = rating;
        this.source = source;
        this.track = track;
        this.uri = uri;
    }

    public final String getArtist() {
        return this.artist;
    }

    public final Integer getLength() {
        return this.length;
    }

    public final Integer getRating() {
        return this.rating;
    }

    public final String getSource() {
        return this.source;
    }

    public final String getTitle() {
        return this.title;
    }

    public final String getTrack() {
        return this.track;
    }

    public final URI getUri() {
        return this.uri;
    }
}

