/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.vcard.temp.model;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.JidAdapter;

@XmlRootElement(name="vCard")
public final class VCard {
    public static final String NAMESPACE = "vcard-temp";
    @XmlAttribute(name="version")
    private String version = "3.0";
    @XmlElement(name="FN")
    private String formattedName;
    @XmlElement(name="N")
    private Name name;
    @XmlElement(name="NICKNAME")
    private String nickName;
    @XmlElement(name="PHOTO")
    private Image photo;
    @XmlJavaTypeAdapter(value=DateFormatterAdapter.class)
    @XmlElement(name="BDAY")
    private Date birthday;
    @XmlElement(name="URL")
    private URL url;
    @XmlElement(name="ORG")
    private Organization organization;
    @XmlElement(name="ADR")
    private List<Address> addresses;
    @XmlElement(name="TEL")
    private List<TelephoneNumber> telephoneNumbers;
    @XmlElement(name="EMAIL")
    private List<Email> emails;
    @XmlElement(name="LABEL")
    private List<AddressLabel> labels;
    @XmlJavaTypeAdapter(value=JidAdapter.class)
    @XmlElement(name="JABBERID")
    private Jid jid;
    @XmlElement(name="MAILER")
    private String mailer;
    @XmlElement(name="TZ")
    private String timezone;
    @XmlElement(name="GEO")
    private Geo geo;
    @XmlElement(name="TITLE")
    private String title;
    @XmlElement(name="ROLE")
    private String role;
    @XmlElement(name="AGENT")
    private String agent;
    @XmlElement(name="LOGO")
    private Image logo;
    @XmlElementWrapper(name="CATEGORIES")
    @XmlElement(name="KEYWORD")
    private List<String> categories;
    @XmlElement(name="NOTE")
    private String note;
    @XmlElement(name="PRODID")
    private String productId;
    @XmlElement(name="REV")
    private Date revision;
    @XmlElement(name="SORT-STRING")
    private String sortString;
    @XmlElement(name="SOUND")
    private String sound;
    @XmlElement(name="UID")
    private String uid;
    @XmlElement(name="KEY")
    private Key key;
    @XmlJavaTypeAdapter(value=ClassificationAdapter.class)
    @XmlElement(name="CLASS")
    private Classification classification;
    @XmlElement(name="DESC")
    private String desc;

    public String getFormattedName() {
        return this.formattedName;
    }

    public void setFormattedName(String formattedName) {
        this.formattedName = formattedName;
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public Image getPhoto() {
        return this.photo;
    }

    public void setPhoto(Image photo) {
        this.photo = photo;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public List<Address> getAddresses() {
        if (this.addresses == null) {
            this.addresses = new ArrayList<Address>();
        }
        return this.addresses;
    }

    public List<TelephoneNumber> getTelephoneNumbers() {
        if (this.telephoneNumbers == null) {
            this.telephoneNumbers = new ArrayList<TelephoneNumber>();
        }
        return this.telephoneNumbers;
    }

    public List<Email> getEmails() {
        if (this.emails == null) {
            this.emails = new ArrayList<Email>();
        }
        return this.emails;
    }

    public List<AddressLabel> getLabels() {
        if (this.labels == null) {
            this.labels = new ArrayList<AddressLabel>();
        }
        return this.labels;
    }

    public Jid getJid() {
        return this.jid;
    }

    public void setJid(Jid jid) {
        this.jid = jid;
    }

    public String getMailer() {
        return this.mailer;
    }

    public void setMailer(String mailer) {
        this.mailer = mailer;
    }

    public String getTimeZone() {
        return this.timezone;
    }

    public void setTimeZone(String timezone) {
        this.timezone = timezone;
    }

    public Geo getGeo() {
        return this.geo;
    }

    public void setGeo(Geo geo) {
        this.geo = geo;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getAgent() {
        return this.agent;
    }

    public void setAgent(String agent) {
        this.agent = agent;
    }

    public Image getLogo() {
        return this.logo;
    }

    public void setLogo(Image logo) {
        this.logo = logo;
    }

    public List<String> getCategories() {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        return this.categories;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public Date getRevision() {
        return this.revision;
    }

    public void setRevision(Date revision) {
        this.revision = revision;
    }

    public String getSortString() {
        return this.sortString;
    }

    public void setSortString(String sortString) {
        this.sortString = sortString;
    }

    public String getSound() {
        return this.sound;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public Key getKey() {
        return this.key;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Classification getClassification() {
        return this.classification;
    }

    public void setClassification(Classification classification) {
        this.classification = classification;
    }

    private static final class Class {
        @XmlElement(name="PUBLIC")
        private String _public;
        @XmlElement(name="PRIVATE")
        private String _private;
        @XmlElement(name="CONFIDENTIAL")
        private String confidential;

        private Class() {
        }
    }

    private static final class ClassificationAdapter
    extends XmlAdapter<Class, Classification> {
        private ClassificationAdapter() {
        }

        public Classification unmarshal(Class v) throws Exception {
            if (v != null) {
                if (v._public != null) {
                    return Classification.PUBLIC;
                }
                if (v._private != null) {
                    return Classification.PRIVATE;
                }
                if (v.confidential != null) {
                    return Classification.CONFIDENTIAL;
                }
            }
            return null;
        }

        public Class marshal(Classification v) throws Exception {
            if (v != null) {
                Class cl = new Class();
                switch (v) {
                    case PUBLIC: {
                        cl._public = "";
                        break;
                    }
                    case PRIVATE: {
                        cl._private = "";
                        break;
                    }
                    case CONFIDENTIAL: {
                        cl.confidential = "";
                    }
                }
                return cl;
            }
            return null;
        }
    }

    private static final class DateFormatterAdapter
    extends XmlAdapter<String, Date> {
        private DateFormatterAdapter() {
        }

        public Date unmarshal(String v) throws Exception {
            if (v != null) {
                Calendar calendar = DatatypeConverter.parseDate((String)v);
                return calendar.getTime();
            }
            return null;
        }

        public String marshal(Date v) throws Exception {
            if (v != null) {
                GregorianCalendar calendar = new GregorianCalendar();
                ((Calendar)calendar).setTimeZone(TimeZone.getTimeZone("GMT"));
                calendar.setTime(v);
                return DatatypeConverter.printDate((Calendar)calendar);
            }
            return null;
        }
    }

    public static final class Key {
        @XmlElement(name="TYPE")
        private String type;
        @XmlElement(name="CRED")
        private String credential;

        public String getCredential() {
            return this.credential;
        }

        public void setCredential(String credential) {
            this.credential = credential;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static final class Sound {
        @XmlElement(name="BINVAL")
        private byte[] value;
        @XmlElement(name="EXTVAL")
        private URI uri;
        @XmlElement(name="PHONETIC")
        private String phonetic;

        public byte[] getValue() {
            return this.value;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public URI getUri() {
            return this.uri;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }

        public String getPhonetic() {
            return this.phonetic;
        }

        public void setPhonetic(String phonetic) {
            this.phonetic = phonetic;
        }
    }

    public static final class Image {
        @XmlElement(name="TYPE")
        private String type;
        @XmlElement(name="BINVAL")
        private byte[] value;
        @XmlElement(name="EXTVAL")
        private URI uri;

        private Image() {
        }

        public Image(String type, byte[] value) {
            this.type = type;
            this.value = value;
        }

        public Image(URI uri) {
            this.uri = uri;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public byte[] getValue() {
            return this.value;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public URI getUri() {
            return this.uri;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }
    }

    public static final class Name {
        @XmlElement(name="FAMILY")
        private String familyName;
        @XmlElement(name="GIVEN")
        private String givenName;
        @XmlElement(name="MIDDLE")
        private String middleName;
        @XmlElement(name="PREFIX")
        private String prefix;
        @XmlElement(name="SUFFIX")
        private String suffix;

        private Name() {
        }

        public Name(String familyName, String givenName, String middleName) {
            this(familyName, givenName, middleName, null, null);
        }

        public Name(String familyName, String givenName, String middleName, String prefix, String suffix) {
            this.familyName = familyName;
            this.givenName = givenName;
            this.middleName = middleName;
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public String getFamilyName() {
            return this.familyName;
        }

        public void setFamilyName(String familyName) {
            this.familyName = familyName;
        }

        public String getGivenName() {
            return this.givenName;
        }

        public void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        public String getMiddleName() {
            return this.middleName;
        }

        public void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }
    }

    public static final class Organization {
        @XmlElement(name="ORGNAME")
        private String organizationName;
        @XmlElement(name="ORGUNIT")
        private List<String> orgUnits = new ArrayList<String>();

        private Organization() {
        }

        public Organization(String organizationName, String ... orgUnits) {
            this.organizationName = organizationName;
            this.orgUnits = Arrays.asList(orgUnits);
        }

        public String getOrganizationName() {
            return this.organizationName;
        }

        public void setOrganizationName(String organizationName) {
            this.organizationName = organizationName;
        }

        public List<String> getOrgUnits() {
            return this.orgUnits;
        }
    }

    public static final class Email
    extends Preferable {
        @XmlElement(name="INTERNET")
        private Boolean internet;
        @XmlElement(name="X400")
        private Boolean x400;
        @XmlElement(name="USERID")
        private String userId;

        private Email() {
            super(false);
        }

        public Email(String email, boolean preferred) {
            this(email, preferred, true, false);
        }

        public Email(String email, boolean preferred, boolean internet, boolean x400) {
            super(preferred);
            this.userId = email;
            this.internet = internet;
            this.x400 = x400;
        }

        public boolean isInternet() {
            return this.internet != null && this.internet != false;
        }

        public void setInternet(boolean internet) {
            this.internet = internet;
        }

        public boolean isX400() {
            return this.x400 != null && this.x400 != false;
        }

        public void setX400(boolean x400) {
            this.x400 = x400;
        }

        public String getEmail() {
            return this.userId;
        }

        public void setEmail(String email) {
            this.userId = email;
        }
    }

    public static class TelephoneNumber
    extends ContactData {
        @XmlElement(name="MSG")
        private Boolean msg;
        @XmlElement(name="VOICE")
        private Boolean voice;
        @XmlElement(name="FAX")
        private Boolean fax;
        @XmlElement(name="CELL")
        private Boolean cell;
        @XmlElement(name="VIDEO")
        private Boolean video;
        @XmlElement(name="PAGER")
        private Boolean pager;
        @XmlElement(name="BBS")
        private Boolean bbs;
        @XmlElement(name="MODEM")
        private Boolean modem;
        @XmlElement(name="PCS")
        private Boolean pcs;
        @XmlElement(name="ISDN")
        private Boolean isdn;
        @XmlElement(name="NUMBER")
        private String number;

        private TelephoneNumber() {
            super(false, false, true);
        }

        public TelephoneNumber(String number, boolean preferred) {
            this(number, preferred, false, true);
        }

        public TelephoneNumber(String number, boolean preferred, boolean home, boolean work) {
            this(number, preferred, home, work, false, true, false, false, false, false, false, false, false, false);
        }

        public TelephoneNumber(String number, boolean preferred, boolean home, boolean work, boolean message, boolean voice, boolean fax, boolean cell, boolean video, boolean pager, boolean bbs, boolean modem, boolean pcs, boolean isdn) {
            super(preferred, home, work);
            this.number = number == null ? "" : number;
            this.voice = voice;
            this.msg = message;
            this.fax = fax;
            this.cell = cell;
            this.video = video;
            this.pager = pager;
            this.bbs = bbs;
            this.modem = modem;
            this.pcs = pcs;
            this.isdn = isdn;
        }

        public boolean isVoice() {
            return this.voice != null && this.voice != false;
        }

        public void setVoice(boolean voice) {
            this.voice = voice;
        }

        public boolean isFax() {
            return this.fax != null && this.fax != false;
        }

        public void setFax(boolean fax) {
            this.fax = fax;
        }

        public boolean isCell() {
            return this.cell != null && this.cell != false;
        }

        public void setCell(boolean cell) {
            this.cell = cell;
        }

        public boolean isVideo() {
            return this.video != null && this.video != false;
        }

        public void setVideo(boolean video) {
            this.video = video;
        }

        public boolean isPager() {
            return this.pager != null && this.pager != false;
        }

        public void setPager(boolean pager) {
            this.pager = pager;
        }

        public boolean isBbs() {
            return this.bbs != null && this.bbs != false;
        }

        public void setBbs(boolean bbs) {
            this.bbs = bbs;
        }

        public boolean isModem() {
            return this.modem != null && this.modem != false;
        }

        public void setModem(boolean modem) {
            this.modem = modem;
        }

        public boolean isPcs() {
            return this.pcs != null && this.pcs != false;
        }

        public void setPcs(boolean pcs) {
            this.pcs = pcs;
        }

        public boolean isIsdn() {
            return this.isdn != null && this.isdn != false;
        }

        public void setIsdn(boolean isdn) {
            this.isdn = isdn;
        }

        public boolean isMsg() {
            return this.msg != null && this.msg != false;
        }

        public void setMsg(boolean msg) {
            this.msg = msg;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }
    }

    @XmlTransient
    private static abstract class Preferable {
        @XmlElement(name="PREF")
        private Boolean pref;

        protected Preferable(boolean preferred) {
            this.pref = preferred;
        }

        public boolean isPreferred() {
            return this.pref != null && this.pref != false;
        }

        public void setPreferred(boolean preferred) {
            this.pref = preferred;
        }
    }

    @XmlTransient
    private static abstract class ContactData
    extends Preferable {
        @XmlElement(name="HOME")
        private Boolean home;
        @XmlElement(name="WORK")
        private Boolean work;

        protected ContactData(boolean preferred, boolean home, boolean work) {
            super(preferred);
            this.home = home;
            this.work = work;
        }

        public boolean isHome() {
            return this.home != null && this.home != false;
        }

        public void setHome(boolean home) {
            this.home = home;
        }

        public boolean isWork() {
            return this.work != null && this.work != false;
        }

        public void setWork(boolean work) {
            this.work = work;
        }
    }

    @XmlTransient
    private static abstract class AbstractAddress
    extends ContactData {
        @XmlElement(name="POSTAL")
        private Boolean postal;
        @XmlElement(name="PARCEL")
        private Boolean parcel;
        @XmlElement(name="INTL")
        private Boolean international;
        @XmlElement(name="DOM")
        private Boolean domestic;

        public AbstractAddress(boolean preferred, boolean home, boolean work, boolean postal, boolean parcel, boolean international) {
            super(preferred, home, work);
            this.postal = postal;
            this.parcel = parcel;
            this.setInternational(international);
        }

        public boolean isInternational() {
            return this.international != null && this.international != false && this.domestic != null && this.domestic == false;
        }

        public void setInternational(boolean international) {
            this.international = international;
            this.domestic = !international;
        }

        public boolean isPostal() {
            return this.postal != null && this.postal != false;
        }

        public void setPostal(boolean postal) {
            this.postal = postal;
        }

        public boolean isParcel() {
            return this.parcel != null && this.parcel != false;
        }

        public void setParcel(boolean parcel) {
            this.parcel = parcel;
        }
    }

    public static class AddressLabel
    extends AbstractAddress {
        @XmlElement(name="LINE")
        private List<String> line;

        private AddressLabel() {
            this(false, false, true, true, true, true, new String[0]);
        }

        public AddressLabel(String ... addressLine) {
            this(false, false, true, true, true, true, addressLine);
        }

        public AddressLabel(boolean preferred, boolean home, boolean work, boolean postal, boolean parcel, boolean international, String ... addressLine) {
            super(preferred, home, work, postal, parcel, international);
            if (addressLine.length == 0 || addressLine[0] == null) {
                throw new IllegalArgumentException("At least one address line must be set.");
            }
            this.line = Arrays.asList(addressLine);
        }
    }

    public static final class Address
    extends AbstractAddress {
        @XmlElement(name="POBOX")
        private String postOfficeBox;
        @XmlElement(name="EXTADD")
        private String extendedAddress;
        @XmlElement(name="STREET")
        private String street;
        @XmlElement(name="LOCALITY")
        private String city;
        @XmlElement(name="REGION")
        private String region;
        @XmlElement(name="PCODE")
        private String postalCode = "";
        @XmlElement(name="CTRY")
        private String country;

        public Address() {
            super(true, false, true, true, true, true);
        }

        public Address(boolean preferred, boolean home, boolean work, boolean postal, boolean parcel, boolean international, String postOfficeBox, String extendedAddress, String street, String city, String region, String postalCode, String country) {
            super(preferred, home, work, postal, parcel, international);
            this.postOfficeBox = postOfficeBox;
            this.extendedAddress = extendedAddress;
            this.street = street;
            this.city = city;
            this.region = region;
            this.postalCode = postalCode;
            this.country = country;
        }

        public Address(String street, String city, String postalCode, String country) {
            super(true, true, false, true, true, true);
            this.street = street;
            this.city = city;
            this.postalCode = postalCode;
            this.country = country;
        }

        public String getPostOfficeBox() {
            return this.postOfficeBox;
        }

        public void setPostOfficeBox(String postOfficeBox) {
            this.postOfficeBox = postOfficeBox;
        }

        public String getExtendedAddress() {
            return this.extendedAddress;
        }

        public void setExtendedAddress(String extendedAddress) {
            this.extendedAddress = extendedAddress;
        }

        public String getStreet() {
            return this.street;
        }

        public void setStreet(String street) {
            this.street = street;
        }

        public String getCity() {
            return this.city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public String getPostalCode() {
            return this.postalCode;
        }

        public void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        public String getCountry() {
            return this.country;
        }

        public void setCountry(String country) {
            this.country = country;
        }
    }

    public static final class Geo {
        @XmlElement(name="LAT")
        private Double latitude;
        @XmlElement(name="LON")
        private Double longitude;

        private Geo() {
        }

        public Geo(double latitude, double longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
        }

        public double getLatitude() {
            return this.latitude != null ? this.latitude : 0.0;
        }

        public void setLatitude(double latitude) {
            this.latitude = latitude;
        }

        public double getLongitude() {
            return this.longitude != null ? this.longitude : 0.0;
        }

        public void setLongitude(double longitude) {
            this.longitude = longitude;
        }
    }

    public static enum Classification {
        PUBLIC,
        PRIVATE,
        CONFIDENTIAL;

    }
}

