/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.jingle.transports.s5b.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.jingle.transports.model.TransportMethod;

@XmlRootElement(name="transport")
public class S5bTransportMethod
extends TransportMethod {
    public static final String NAMESPACE = "urn:xmpp:jingle:transports:s5b:1";
    private final List<Candidate> candidate = new ArrayList<Candidate>();
    @XmlAttribute
    private String dstaddr;
    @XmlAttribute
    private Mode mode = Mode.TCP;
    @XmlAttribute
    private String sid;

    public String getDstAddr() {
        return this.dstaddr;
    }

    public String getSessionId() {
        return this.sid;
    }

    public Mode getMode() {
        return this.mode;
    }

    public List<Candidate> getCandidates() {
        return this.candidate;
    }

    private static final class Activated {
        @XmlAttribute
        private String cid;

        private Activated() {
        }
    }

    private static final class CandidateUsed {
        @XmlAttribute
        private String cid;

        private CandidateUsed() {
        }
    }

    public static final class Candidate
    implements Comparable<Candidate> {
        @XmlAttribute
        private String cid;
        @XmlAttribute
        private String host;
        @XmlAttribute
        private Jid jid;
        @XmlAttribute
        private int port;
        @XmlAttribute
        private int priority;
        @XmlAttribute
        private Type type = Type.DIRECT;

        private Candidate() {
        }

        public Candidate(String cid, String host, Jid jid, int localPriority) {
            this.cid = cid;
            this.host = host;
            this.jid = jid;
            this.priority = this.calculatePriority(localPriority);
        }

        public Candidate(String cid, String host, Jid jid, int localPriority, Type type, int port) {
            this.cid = cid;
            this.host = host;
            this.jid = jid;
            this.type = type;
            this.port = port;
            this.priority = this.calculatePriority(localPriority);
        }

        private int calculatePriority(int localPreference) {
            return 65536 * (this.type == null ? Type.DIRECT.getPreferenceValue() : this.type.getPreferenceValue()) + localPreference;
        }

        public String getCid() {
            return this.cid;
        }

        public String getHost() {
            return this.host;
        }

        public Jid getJid() {
            return this.jid;
        }

        public int getPort() {
            return this.port;
        }

        public int getPriority() {
            return this.priority;
        }

        public Type getType() {
            return this.type;
        }

        @Override
        public int compareTo(Candidate o) {
            return Integer.compare(o.priority, this.priority);
        }

        public static enum Type {
            ASSISTED(120),
            DIRECT(126),
            PROXY(10),
            TUNNEL(110);

            private final int preferenceValue;

            private Type(int preferenceValue) {
                this.preferenceValue = preferenceValue;
            }

            public int getPreferenceValue() {
                return this.preferenceValue;
            }
        }
    }

    public static enum Mode {
        TCP,
        UDP;

    }
}

