/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.privatedata.rosternotes.model;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import rocks.xmpp.addr.Jid;

@XmlRootElement(name="storage")
public final class Annotation {
    public static final String NAMESPACE = "storage:rosternotes";
    private final List<Note> note = new ArrayList<Note>();

    private Annotation() {
    }

    public Annotation(Collection<Note> notes) {
        if (notes != null) {
            this.note.addAll(notes);
        }
    }

    public final List<Note> getNotes() {
        return Collections.unmodifiableList(this.note);
    }

    public static final class Note {
        @XmlAttribute
        private final Jid jid;
        @XmlAttribute
        private final OffsetDateTime cdate;
        @XmlAttribute
        private final OffsetDateTime mdate;
        @XmlValue
        private final String value;

        private Note() {
            this.value = null;
            this.jid = null;
            this.cdate = null;
            this.mdate = null;
        }

        public Note(String note, Jid jid) {
            this(note, jid, null, null);
        }

        public Note(String note, Jid jid, OffsetDateTime creationDate, OffsetDateTime modificationDate) {
            this.value = note;
            this.jid = Objects.requireNonNull(jid, "jid must not be null.").asBareJid();
            this.cdate = creationDate;
            this.mdate = modificationDate;
        }

        public final String getValue() {
            return this.value;
        }

        public final OffsetDateTime getModificationDate() {
            return this.mdate;
        }

        public final OffsetDateTime getCreationDate() {
            return this.cdate;
        }

        public final Jid getJid() {
            return this.jid;
        }

        public final String toString() {
            return this.value;
        }
    }
}

