/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rpc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import rocks.xmpp.extensions.rpc.model.Parameter;
import rocks.xmpp.extensions.rpc.model.Value;

@XmlRootElement(name="query")
public final class Rpc {
    public static final String NAMESPACE = "jabber:iq:rpc";
    private MethodCall methodCall;
    private MethodResponse methodResponse;

    private Rpc() {
    }

    @Deprecated
    public Rpc(String methodName, Value ... parameters) {
        this.methodCall = new MethodCall(methodName, parameters);
    }

    @Deprecated
    public Rpc(Value value) {
        this.methodResponse = new MethodResponse(value);
    }

    @Deprecated
    public Rpc(MethodResponse.Fault fault) {
        this.methodResponse = new MethodResponse(fault);
    }

    public static Rpc ofMethodCall(String methodName, Value ... parameters) {
        return new Rpc(methodName, parameters);
    }

    public static Rpc ofMethodResponse(Value value) {
        return new Rpc(value);
    }

    public static Rpc ofFaultResponse(int faultCode, String faultString) {
        return new Rpc(new MethodResponse.Fault(faultCode, faultString));
    }

    public final MethodCall getMethodCall() {
        return this.methodCall;
    }

    public final MethodResponse getMethodResponse() {
        return this.methodResponse;
    }

    public final String toString() {
        if (this.methodCall != null) {
            return this.methodCall.toString();
        }
        if (this.methodResponse != null) {
            return this.methodResponse.toString();
        }
        return super.toString();
    }

    public static final class MethodResponse {
        @XmlElementWrapper(name="params")
        @XmlElement(name="param")
        private final List<Parameter> parameters = new ArrayList<Parameter>();
        private final Fault fault;

        private MethodResponse() {
            this.fault = null;
        }

        private MethodResponse(Value value) {
            this.parameters.add(new Parameter(value));
            this.fault = null;
        }

        private MethodResponse(Fault fault) {
            this.fault = fault;
        }

        public final Value getResponse() {
            if (!this.parameters.isEmpty()) {
                return this.parameters.get(0).getValue();
            }
            return null;
        }

        public final Fault getFault() {
            return this.fault;
        }

        public final String toString() {
            if (this.fault != null) {
                return this.fault.toString();
            }
            return "Response: " + this.parameters.get(0);
        }

        public static final class Fault {
            private Value value;

            private Fault() {
            }

            @Deprecated
            public Fault(int faultCode, String faultString) {
                LinkedHashMap<String, Value> faultMap = new LinkedHashMap<String, Value>();
                faultMap.put("faultCode", Value.of(faultCode));
                faultMap.put("faultString", Value.of(faultString));
                this.value = new Value(faultMap);
            }

            public final int getFaultCode() {
                Integer value;
                Value faultCode;
                Map<String, Value> map;
                if (this.value != null && (map = this.value.getAsMap()) != null && (faultCode = map.get("faultCode")) != null && (value = faultCode.getAsInteger()) != null) {
                    return value;
                }
                return 0;
            }

            public final String getFaultString() {
                Value faultCode;
                Map<String, Value> map;
                if (this.value != null && (map = this.value.getAsMap()) != null && (faultCode = map.get("faultString")) != null) {
                    return faultCode.getAsString();
                }
                return null;
            }

            public final String toString() {
                return "FaultCode: " + this.getFaultCode() + "; FaultString: " + this.getFaultString();
            }
        }
    }

    @XmlType(propOrder={"methodName", "parameters"})
    public static final class MethodCall {
        @XmlElementWrapper(name="params")
        @XmlElement(name="param")
        private final List<Parameter> parameters = new ArrayList<Parameter>();
        private final String methodName;

        private MethodCall() {
            this.methodName = null;
        }

        MethodCall(String methodName, Value ... parameters) {
            this.methodName = Objects.requireNonNull(methodName);
            for (Value value : parameters) {
                this.parameters.add(new Parameter(value));
            }
        }

        public final String getMethodName() {
            return this.methodName;
        }

        public final List<Value> getParameters() {
            List values = this.parameters.stream().map(Parameter::getValue).collect(Collectors.toList());
            return Collections.unmodifiableList(values);
        }

        public final String toString() {
            return this.methodName + '(' + String.join((CharSequence)", ", this.parameters.stream().map(Object::toString).collect(Collectors.toList())) + ')';
        }
    }
}

