/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rtt.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;

@XmlRootElement(name="rtt")
public final class RealTimeText {
    public static final String NAMESPACE = "urn:xmpp:rtt:0";
    @XmlElements(value={@XmlElement(name="t", type=InsertText.class), @XmlElement(name="e", type=EraseText.class), @XmlElement(name="w", type=WaitInterval.class)})
    private final List<Action> actions = new ArrayList<Action>();
    @XmlAttribute(name="seq")
    private Integer sequence;
    @XmlAttribute(name="event")
    private Event event;
    @XmlAttribute(name="id")
    private String id;

    private RealTimeText() {
    }

    public RealTimeText(Event event, Collection<Action> actions, int sequence, String id) {
        this.event = event;
        this.actions.addAll(actions);
        this.sequence = sequence;
        this.id = id;
    }

    public Event getEvent() {
        return this.event;
    }

    public Integer getSequence() {
        return this.sequence;
    }

    public List<Action> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public String getId() {
        return this.id;
    }

    public static final class WaitInterval
    extends Action {
        @XmlAttribute(name="n")
        private Long milliSeconds;

        private WaitInterval() {
        }

        public WaitInterval(long milliSeconds) {
            this.milliSeconds = milliSeconds;
        }

        public Long getMilliSeconds() {
            return this.milliSeconds;
        }

        public String toString() {
            return "Wait " + this.milliSeconds + " ms";
        }
    }

    public static final class EraseText
    extends Action {
        @XmlAttribute(name="p")
        private Integer position;
        @XmlAttribute(name="n")
        private Integer numberOfCharacters;

        public EraseText() {
        }

        public EraseText(Integer n) {
            if (n != null && n < 0) {
                throw new IllegalArgumentException("n must not be < 0");
            }
            this.numberOfCharacters = n;
        }

        public EraseText(Integer n, Integer p) {
            if (n != null && n < 0) {
                throw new IllegalArgumentException("n must not be < 0");
            }
            if (p != null && p < 0) {
                throw new IllegalArgumentException("p must not be < 0");
            }
            this.numberOfCharacters = n;
            this.position = p;
        }

        public Integer getPosition() {
            return this.position;
        }

        public Integer getNumberOfCharacters() {
            return this.numberOfCharacters;
        }

        public String toString() {
            return "Erase " + (this.numberOfCharacters != null ? this.numberOfCharacters : 1) + " character(s) at " + (this.position != null ? "position " + this.position : "last position");
        }
    }

    public static final class InsertText
    extends Action {
        @XmlValue
        private String text;
        @XmlAttribute(name="p")
        private Integer position;

        private InsertText() {
        }

        public InsertText(String text) {
            this.text = text;
        }

        public InsertText(String text, Integer position) {
            if (position != null && position < 0) {
                throw new IllegalArgumentException("position must not be < 0");
            }
            this.text = text;
            this.position = position;
        }

        public String getText() {
            return this.text;
        }

        public Integer getPosition() {
            return this.position;
        }

        public String toString() {
            return "Insert '" + (this.text != null ? this.text : "") + "'" + (this.position != null ? " at position " + this.position : "");
        }
    }

    @XmlTransient
    public static abstract class Action {
    }

    public static enum Event {
        NEW,
        RESET,
        EDIT,
        INIT,
        CANCEL;

    }
}

