/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.jingle.apps.filetransfer.model;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.extensions.filetransfer.FileTransferOffer;
import rocks.xmpp.extensions.filetransfer.Range;
import rocks.xmpp.extensions.hashes.model.Hash;
import rocks.xmpp.extensions.jingle.apps.model.ApplicationFormat;
import rocks.xmpp.util.adapters.InstantAdapter;

@XmlRootElement(name="description")
@XmlSeeAlso(value={Checksum.class})
public final class JingleFileTransfer
extends ApplicationFormat {
    public static final String NAMESPACE = "urn:xmpp:jingle:apps:file-transfer:4";
    private File file;

    private JingleFileTransfer() {
    }

    public JingleFileTransfer(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @XmlRootElement
    public static final class Checksum {
        private File file;

        private Checksum() {
        }

        public Checksum(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }

    public static class File
    implements FileTransferOffer {
        @XmlElementRef
        private final List<Hash> hashes = new ArrayList<Hash>();
        @XmlJavaTypeAdapter(value=InstantAdapter.class)
        private Instant date;
        private String desc;
        @XmlElement(name="media-type")
        private String mediaType;
        private String name;
        private long size;

        private File() {
        }

        public File(String name, long size) {
            this.name = name;
            this.size = size;
        }

        public File(String name, long size, Instant lastModified, String hash, String description) {
            this.name = name;
            this.size = size;
            this.date = lastModified;
            this.desc = description;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Instant getDate() {
            return this.date;
        }

        @Override
        public List<Hash> getHashes() {
            return Collections.unmodifiableList(this.hashes);
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public Range getRange() {
            return null;
        }

        public String getMediaType() {
            return this.mediaType;
        }
    }
}

