/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc.model.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.muc.model.Actor;
import rocks.xmpp.extensions.muc.model.Affiliation;
import rocks.xmpp.extensions.muc.model.Item;
import rocks.xmpp.extensions.muc.model.Role;

@XmlRootElement(name="query")
public final class MucAdmin {
    private final List<MucAdminItem> item = new ArrayList<MucAdminItem>();

    private MucAdmin() {
    }

    private MucAdmin(Item ... items) {
        for (Item item : items) {
            this.item.add(new MucAdminItem(item));
        }
    }

    public static MucAdmin withItem(Role role) {
        return new MucAdmin(new MucAdminItem(role, null, null));
    }

    public static MucAdmin withItem(Affiliation affiliation) {
        return new MucAdmin(new MucAdminItem(affiliation, null, null));
    }

    public static MucAdmin withItem(Role role, String nick, String reason) {
        return new MucAdmin(new MucAdminItem(role, nick, reason));
    }

    public static MucAdmin withItem(Affiliation affiliation, Jid jid, String reason) {
        return new MucAdmin(new MucAdminItem(affiliation, jid, reason));
    }

    public static MucAdmin withItems(List<Item> items) {
        Item[] array = new Item[items.size()];
        items.toArray(array);
        return new MucAdmin(array);
    }

    public static MucAdmin withItems(Item ... items) {
        return new MucAdmin(items);
    }

    public static Item createItem(Affiliation affiliation, Role role, Jid jid, String nick, Actor actor, String reason) {
        return new MucAdminItem(affiliation, role, jid, nick, actor, reason);
    }

    public static Item createItem(Role role, String nick, String reason) {
        return new MucAdminItem(role, nick, reason);
    }

    public static Item createItem(Role role, String nick) {
        return new MucAdminItem(role, nick, null);
    }

    public static Item createItem(Role role) {
        return new MucAdminItem(role, null, null);
    }

    public static Item createItem(Affiliation affiliation) {
        return new MucAdminItem(affiliation, null, null);
    }

    public static Item createItem(Affiliation affiliation, Jid jid) {
        return new MucAdminItem(affiliation, jid, null);
    }

    public static Item createItem(Affiliation affiliation, Jid jid, String reason) {
        return new MucAdminItem(affiliation, jid, reason);
    }

    public static Item createItem(Affiliation affiliation, Jid jid, String nick, String reason) {
        return new MucAdminItem(affiliation, null, jid, nick, null, reason);
    }

    public List<? extends Item> getItems() {
        return Collections.unmodifiableList(this.item);
    }

    private static final class MucAdminItem
    implements Item {
        private MucAdminActor actor;
        private String reason;
        @XmlAttribute
        private Affiliation affiliation;
        @XmlAttribute
        private Jid jid;
        @XmlAttribute
        private String nick;
        @XmlAttribute
        private Role role;

        private MucAdminItem() {
        }

        private MucAdminItem(Affiliation affiliation, Jid jid, String reason) {
            this(affiliation, null, jid, null, null, reason);
        }

        private MucAdminItem(Affiliation affiliation, Role role, Jid jid, String nick, Actor actor, String reason) {
            this.affiliation = affiliation;
            this.role = role;
            this.jid = jid;
            this.nick = nick;
            this.actor = actor != null ? new MucAdminActor(actor) : null;
            this.reason = reason;
        }

        private MucAdminItem(Role role, String nick, String reason) {
            this.role = role;
            this.nick = nick;
            this.reason = reason;
        }

        private MucAdminItem(Item item) {
            if (item.getActor() != null) {
                this.actor = new MucAdminActor(item.getActor());
            }
            this.affiliation = item.getAffiliation();
            this.jid = item.getJid();
            this.role = item.getRole();
            this.nick = item.getNick();
            this.reason = item.getReason();
        }

        @Override
        public String getNick() {
            return this.nick;
        }

        @Override
        public Role getRole() {
            return this.role;
        }

        @Override
        public Jid getJid() {
            return this.jid;
        }

        @Override
        public Affiliation getAffiliation() {
            return this.affiliation;
        }

        @Override
        public String getReason() {
            return this.reason;
        }

        @Override
        public Actor getActor() {
            return this.actor;
        }

        private static final class MucAdminActor
        implements Actor {
            @XmlAttribute
            private Jid jid;
            @XmlAttribute
            private String nick;

            private MucAdminActor() {
            }

            private MucAdminActor(Actor actor) {
                this.jid = actor.getJid();
                this.nick = actor.getNick();
            }

            @Override
            public String getNick() {
                return this.nick;
            }

            @Override
            public Jid getJid() {
                return this.jid;
            }
        }
    }
}

