/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub.model;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.data.model.DataForm;

public final class NodeMetaData {
    public static final String FORM_TYPE = "http://jabber.org/protocol/pubsub#meta-data";
    private static final String CONTACT = "pubsub#contact";
    private static final String CREATION_DATE = "pubsub#creation_date";
    private static final String CREATOR = "pubsub#creator";
    private static final String DESCRIPTION = "pubsub#description";
    private static final String LANGUAGE = "pubsub#language";
    private static final String NUM_SUBSCRIBERS = "pubsub#num_subscribers";
    private static final String OWNER = "pubsub#owner";
    private static final String PUBLISHER = "pubsub#publisher";
    private static final String TITLE = "pubsub#title";
    private static final String TYPE = "pubsub#type";
    private final DataForm dataForm;

    public NodeMetaData(DataForm dataForm) {
        this.dataForm = dataForm;
    }

    public static Builder builder() {
        return new Builder();
    }

    public final DataForm getDataForm() {
        return this.dataForm;
    }

    public final List<Jid> getContacts() {
        return this.dataForm.findValuesAsJid(CONTACT);
    }

    public final Instant getCreationDate() {
        return this.dataForm.findValueAsInstant(CREATION_DATE);
    }

    public final Jid getCreator() {
        return this.dataForm.findValueAsJid(CREATOR);
    }

    public final String getDescription() {
        return this.dataForm.findValue(DESCRIPTION);
    }

    public final String getLanguage() {
        return this.dataForm.findValue(LANGUAGE);
    }

    public final Integer getNumberOfSubscribers() {
        return this.dataForm.findValueAsInteger(NUM_SUBSCRIBERS);
    }

    public final List<Jid> getOwners() {
        return this.dataForm.findValuesAsJid(OWNER);
    }

    public final List<Jid> getPublishers() {
        return this.dataForm.findValuesAsJid(PUBLISHER);
    }

    public final String getNodeTitle() {
        return this.dataForm.findValue(TITLE);
    }

    public final String getPayloadType() {
        return this.dataForm.findValue(TYPE);
    }

    public static final class Builder
    extends DataForm.Builder<Builder> {
        private Collection<Jid> contacts;
        private Instant creationDate;
        private Jid creator;
        private String description;
        private String language;
        private Integer numberOfSubscribers;
        private Collection<Jid> owners;
        private Collection<Jid> publishers;
        private String nodeTitle;
        private String payloadType;

        private Builder() {
        }

        public final Builder contacts(Collection<Jid> contacts) {
            this.contacts = contacts;
            return this;
        }

        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Builder creator(Jid creator) {
            this.creator = creator;
            return this;
        }

        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final Builder numberOfSubscribers(int numberOfSubscribers) {
            this.numberOfSubscribers = numberOfSubscribers;
            return this;
        }

        public final Builder owners(Collection<Jid> owners) {
            this.owners = owners;
            return this;
        }

        public final Builder publishers(Collection<Jid> publishers) {
            this.publishers = publishers;
            return this;
        }

        public final Builder nodeTitle(String title) {
            this.nodeTitle = title;
            return this;
        }

        public final Builder payloadType(String payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        protected final Builder self() {
            return this;
        }

        public final NodeMetaData build() {
            ArrayList<DataForm.Field> fields = new ArrayList<DataForm.Field>();
            if (this.contacts != null && !this.contacts.isEmpty()) {
                fields.add(DataForm.Field.builder().var(NodeMetaData.CONTACT).valuesJid(this.contacts).build());
            }
            if (this.creationDate != null) {
                fields.add(DataForm.Field.builder().var(NodeMetaData.CREATION_DATE).value(this.creationDate).build());
            }
            if (this.creator != null) {
                fields.add(DataForm.Field.builder().var(NodeMetaData.CREATOR).value(this.creator).build());
            }
            if (this.description != null) {
                fields.add(DataForm.Field.builder().var(NodeMetaData.DESCRIPTION).value(this.description).build());
            }
            if (this.language != null) {
                fields.add(DataForm.Field.builder().var(NodeMetaData.LANGUAGE).value(this.language).type(DataForm.Field.Type.LIST_SINGLE).build());
            }
            if (this.numberOfSubscribers != null) {
                fields.add(DataForm.Field.builder().var(NodeMetaData.NUM_SUBSCRIBERS).value(this.numberOfSubscribers.intValue()).build());
            }
            if (this.owners != null && !this.owners.isEmpty()) {
                fields.add(DataForm.Field.builder().var(NodeMetaData.OWNER).valuesJid(this.owners).build());
            }
            if (this.publishers != null && !this.publishers.isEmpty()) {
                fields.add(DataForm.Field.builder().var(NodeMetaData.PUBLISHER).valuesJid(this.publishers).build());
            }
            if (this.nodeTitle != null) {
                fields.add(DataForm.Field.builder().var(NodeMetaData.TITLE).value(this.nodeTitle).build());
            }
            if (this.payloadType != null) {
                fields.add(DataForm.Field.builder().var(NodeMetaData.TYPE).value(this.payloadType).build());
            }
            ((Builder)((Builder)this.fields(fields)).formType(NodeMetaData.FORM_TYPE)).type(DataForm.Type.RESULT);
            return new NodeMetaData(new DataForm((DataForm.Builder)this));
        }
    }
}

