/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rpc.model;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import rocks.xmpp.extensions.rpc.model.ArrayType;
import rocks.xmpp.extensions.rpc.model.NumericBoolean;
import rocks.xmpp.extensions.rpc.model.StructType;

public final class Value {
    @XmlElements(value={@XmlElement(name="i4", type=Integer.class), @XmlElement(name="int", type=Integer.class), @XmlElement(name="string", type=String.class), @XmlElement(name="double", type=Double.class), @XmlElement(name="base64", type=byte[].class), @XmlElement(name="boolean", type=NumericBoolean.class), @XmlElement(name="dateTime.iso8601", type=XMLGregorianCalendar.class), @XmlElement(name="array", type=ArrayType.class), @XmlElement(name="struct", type=StructType.class)})
    private final Object value;

    private Value() {
        this.value = null;
    }

    @Deprecated
    public Value(Integer integer) {
        this.value = integer;
    }

    @Deprecated
    public Value(String string) {
        this.value = string;
    }

    @Deprecated
    public Value(Double d) {
        this.value = d;
    }

    @Deprecated
    public Value(byte[] bytes) {
        this.value = bytes;
    }

    @Deprecated
    public Value(Boolean b) {
        this.value = new NumericBoolean(b);
    }

    @Deprecated
    public Value(OffsetDateTime date) {
        XMLGregorianCalendar xmlGregorianCalendar;
        try {
            xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
            xmlGregorianCalendar.setYear(date.getYear());
            xmlGregorianCalendar.setMonth(date.getMonth().getValue());
            xmlGregorianCalendar.setDay(date.getDayOfMonth());
            xmlGregorianCalendar.setTime(date.getHour(), date.getMinute(), date.getSecond());
            xmlGregorianCalendar.setTimezone(date.getOffset().getTotalSeconds() / 60);
        }
        catch (DatatypeConfigurationException e) {
            xmlGregorianCalendar = null;
        }
        this.value = xmlGregorianCalendar;
    }

    @Deprecated
    public Value(Collection<Value> list) {
        if (list != null) {
            ArrayType arrayType = new ArrayType();
            arrayType.values.addAll(list.stream().collect(Collectors.toList()));
            this.value = arrayType;
        } else {
            this.value = null;
        }
    }

    @Deprecated
    public Value(Map<String, Value> map) {
        if (map != null) {
            StructType structType = new StructType();
            structType.member.addAll(map.entrySet().stream().map(entry -> new StructType.MemberType((String)entry.getKey(), (Value)entry.getValue())).collect(Collectors.toList()));
            this.value = structType;
        } else {
            this.value = null;
        }
    }

    public static Value of(Integer integer) {
        return new Value(integer);
    }

    public static Value of(String string) {
        return new Value(string);
    }

    public static Value of(Double d) {
        return new Value(d);
    }

    public static Value of(byte[] bytes) {
        return new Value(bytes);
    }

    public static Value of(Boolean b) {
        return new Value(b);
    }

    public static Value of(OffsetDateTime dateTime) {
        return new Value(dateTime);
    }

    public static Value of(Collection<Value> list) {
        return new Value(list);
    }

    public static Value of(Map<String, Value> map) {
        return new Value(map);
    }

    public final Integer getAsInteger() {
        return this.value instanceof Integer ? (Integer)this.value : null;
    }

    public final Double getAsDouble() {
        return this.value instanceof Double ? (Double)this.value : null;
    }

    public final String getAsString() {
        return this.value instanceof String ? (String)this.value : null;
    }

    public final byte[] getAsByteArray() {
        return this.value instanceof byte[] ? (byte[])this.value : null;
    }

    public final Boolean getAsBoolean() {
        return this.value instanceof NumericBoolean ? ((NumericBoolean)this.value).getAsBoolean() : null;
    }

    public final OffsetDateTime getAsInstant() {
        if (this.value instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar calendar = (XMLGregorianCalendar)this.value;
            return OffsetDateTime.of(calendar.getYear(), calendar.getMonth(), calendar.getDay(), calendar.getHour(), calendar.getMinute(), calendar.getSecond(), 0, ZoneOffset.ofTotalSeconds(calendar.getTimezone() * 60));
        }
        return null;
    }

    public final List<Value> getAsArray() {
        if (this.value instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)this.value;
            return arrayType.values.stream().collect(Collectors.toList());
        }
        return null;
    }

    public final Map<String, Value> getAsMap() {
        if (this.value instanceof StructType) {
            StructType structType = (StructType)this.value;
            HashMap<String, Value> result = new HashMap<String, Value>();
            for (StructType.MemberType member : structType.member) {
                result.put(member.name, member.value);
            }
            return result;
        }
        return null;
    }

    public final String toString() {
        return this.value.toString();
    }
}

