/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.xhtmlim.model;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@XmlRootElement
public final class Html {
    public static final String NAMESPACE = "http://jabber.org/protocol/xhtml-im";
    @XmlElement(name="body", namespace="http://www.w3.org/1999/xhtml")
    private final Object body;

    private Html() {
        this.body = null;
    }

    public Html(Document document) {
        this.body = document.createElement("body");
    }

    public Html(String xhtmlContent) throws SAXException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader("<body>" + Objects.requireNonNull(xhtmlContent) + "</body>")));
            this.body = document.getDocumentElement();
        }
        catch (IOException | ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public final Element getBody() {
        return (Element)this.body;
    }

    public final String getContent() {
        if (this.body != null) {
            try {
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer transformer = transFactory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                StringWriter writer = new StringWriter();
                transformer.transform(new DOMSource((Element)this.body), new StreamResult(writer));
                String body = writer.toString();
                return body.substring(body.indexOf(62) + 1, body.lastIndexOf(60));
            }
            catch (TransformerException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public final String toString() {
        return this.getContent();
    }
}

