/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.data.model.DataForm;

public final class RoomInfo {
    public static final String FORM_TYPE = "http://jabber.org/protocol/muc#roominfo";
    private static final String MAX_HISTORY_FETCH = "muc#maxhistoryfetch";
    private static final String CONTACT_JID = "muc#roominfo_contactjid";
    private static final String DESCRIPTION = "muc#roominfo_description";
    private static final String LANGUAGE = "muc#roominfo_lang";
    private static final String LDAP_GROUP = "muc#roominfo_ldapgroup";
    private static final String LOGS = "muc#roominfo_logs";
    private static final String OCCUPANTS = "muc#roominfo_occupants";
    private static final String SUBJECT = "muc#roominfo_subject";
    private static final String SUBJECT_MOD = "muc#roominfo_subjectmod";
    private final DataForm dataForm;

    public RoomInfo(DataForm dataForm) {
        this.dataForm = dataForm;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Integer getMaxHistoryMessages() {
        return this.dataForm.findValueAsInteger(MAX_HISTORY_FETCH);
    }

    public List<Jid> getContacts() {
        return this.dataForm.findValuesAsJid(CONTACT_JID);
    }

    public String getDescription() {
        return this.dataForm.findValue(DESCRIPTION);
    }

    public String getLanguage() {
        return this.dataForm.findValue(LANGUAGE);
    }

    public String getLdapGroup() {
        return this.dataForm.findValue(LDAP_GROUP);
    }

    public URL getLogs() {
        String value = this.dataForm.findValue(LOGS);
        if (value != null) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    public Integer getCurrentNumberOfOccupants() {
        return this.dataForm.findValueAsInteger(OCCUPANTS);
    }

    public String getSubject() {
        return this.dataForm.findValue(SUBJECT);
    }

    public boolean isChangeSubjectAllowed() {
        return this.dataForm.findValueAsBoolean(SUBJECT_MOD);
    }

    public DataForm getDataForm() {
        return this.dataForm;
    }

    public static final class Builder
    extends DataForm.Builder<Builder> {
        private Integer maxHistoryMessages;
        private Collection<Jid> contacts;
        private String description;
        private String language;
        private String ldapGroup;
        private URL logs;
        private Integer occupants;
        private String subject;
        private Boolean changeSubjectAllowed;

        private Builder() {
        }

        public Builder maxHistoryMessages(int maxHistoryMessages) {
            this.maxHistoryMessages = maxHistoryMessages;
            return this;
        }

        public Builder contacts(Collection<Jid> contacts) {
            this.contacts = contacts;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder ldapGroup(String ldapGroup) {
            this.ldapGroup = ldapGroup;
            return this;
        }

        public Builder logs(URL logs) {
            this.logs = logs;
            return this;
        }

        public Builder currentNumberOfOccupants(int occupants) {
            this.occupants = occupants;
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder changeSubjectAllowed(boolean changeSubjectAllowed) {
            this.changeSubjectAllowed = changeSubjectAllowed;
            return this;
        }

        protected Builder self() {
            return this;
        }

        public RoomInfo build() {
            ArrayDeque<DataForm.Field> fields = new ArrayDeque<DataForm.Field>();
            if (this.maxHistoryMessages != null) {
                fields.add(DataForm.Field.builder().var(RoomInfo.MAX_HISTORY_FETCH).value(this.maxHistoryMessages.intValue()).build());
            }
            if (this.contacts != null && !this.contacts.isEmpty()) {
                fields.add(DataForm.Field.builder().var(RoomInfo.CONTACT_JID).valuesJid(this.contacts).build());
            }
            if (this.description != null) {
                fields.add(DataForm.Field.builder().var(RoomInfo.DESCRIPTION).value(this.description).build());
            }
            if (this.language != null) {
                fields.add(DataForm.Field.builder().var(RoomInfo.LANGUAGE).value(this.language).build());
            }
            if (this.ldapGroup != null) {
                fields.add(DataForm.Field.builder().var(RoomInfo.LDAP_GROUP).value(this.ldapGroup).build());
            }
            if (this.logs != null) {
                fields.add(DataForm.Field.builder().var(RoomInfo.LOGS).value(this.logs.toString()).build());
            }
            if (this.occupants != null) {
                fields.add(DataForm.Field.builder().var(RoomInfo.OCCUPANTS).value(this.occupants.intValue()).build());
            }
            if (this.subject != null) {
                fields.add(DataForm.Field.builder().var(RoomInfo.SUBJECT).value(this.subject).build());
            }
            if (this.changeSubjectAllowed != null) {
                fields.add(DataForm.Field.builder().var(RoomInfo.SUBJECT_MOD).value(this.changeSubjectAllowed.booleanValue()).build());
            }
            ((Builder)((Builder)this.fields(fields)).formType(RoomInfo.FORM_TYPE)).type(DataForm.Type.RESULT);
            return new RoomInfo(new DataForm((DataForm.Builder)this));
        }
    }
}

