/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.time.model;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.util.adapters.InstantAdapter;
import rocks.xmpp.util.adapters.ZoneOffsetAdapter;

@XmlRootElement(name="time")
public final class EntityTime {
    public static final String NAMESPACE = "urn:xmpp:time";
    @XmlJavaTypeAdapter(value=ZoneOffsetAdapter.class)
    private final ZoneOffset tzo;
    @XmlJavaTypeAdapter(value=InstantAdapter.class)
    private final Instant utc;

    public EntityTime() {
        this.tzo = null;
        this.utc = null;
    }

    public EntityTime(OffsetDateTime dateTime) {
        this.tzo = Objects.requireNonNull(dateTime).getOffset();
        this.utc = dateTime.toInstant();
    }

    public final OffsetDateTime getDateTime() {
        return this.utc != null ? OffsetDateTime.ofInstant(this.utc, this.tzo != null ? this.tzo : ZoneOffset.UTC) : null;
    }

    public final String toString() {
        OffsetDateTime dateTime = this.getDateTime();
        if (dateTime != null) {
            return dateTime.toString();
        }
        return super.toString();
    }
}

