/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bookmarks.model;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.bookmarks.model.Bookmark;

public final class ChatRoomBookmark
extends Bookmark {
    private final String nick;
    private final String password;
    @XmlAttribute
    private final Boolean autojoin;
    @XmlAttribute
    private final Jid jid;

    private ChatRoomBookmark() {
        super(null);
        this.jid = null;
        this.nick = null;
        this.password = null;
        this.autojoin = null;
    }

    public ChatRoomBookmark(String name, Jid room) {
        super(name);
        this.jid = Objects.requireNonNull(room);
        this.nick = null;
        this.password = null;
        this.autojoin = null;
    }

    public ChatRoomBookmark(String name, Jid room, String nick, String password, boolean autojoin) {
        super(name);
        this.jid = room;
        this.nick = nick;
        this.password = password;
        this.autojoin = autojoin;
    }

    public final String getNick() {
        return this.nick;
    }

    public final String getPassword() {
        return this.password;
    }

    public final boolean isAutojoin() {
        return this.autojoin != null && this.autojoin != false;
    }

    public final Jid getRoom() {
        return this.jid;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatRoomBookmark)) {
            return false;
        }
        ChatRoomBookmark other = (ChatRoomBookmark)o;
        return Objects.equals(this.jid, other.jid);
    }

    public final int hashCode() {
        return Objects.hash(this.jid);
    }

    public final String toString() {
        return this.getName() + ": " + (this.jid != null ? this.jid.toString() : "");
    }
}

