/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.activity.model;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import rocks.xmpp.extensions.activity.model.Category;
import rocks.xmpp.extensions.activity.model.SpecificActivity;

@XmlRootElement
public final class Activity {
    public static final String NAMESPACE = "http://jabber.org/protocol/activity";
    @XmlElements(value={@XmlElement(name="doing_chores", type=AbstractCategory.DoingChores.class), @XmlElement(name="drinking", type=AbstractCategory.Drinking.class), @XmlElement(name="eating", type=AbstractCategory.Eating.class), @XmlElement(name="exercising", type=AbstractCategory.Exercising.class), @XmlElement(name="grooming", type=AbstractCategory.Grooming.class), @XmlElement(name="having_appointment", type=AbstractCategory.HavingAppointment.class), @XmlElement(name="inactive", type=AbstractCategory.Inactive.class), @XmlElement(name="relaxing", type=AbstractCategory.Relaxing.class), @XmlElement(name="talking", type=AbstractCategory.Talking.class), @XmlElement(name="traveling", type=AbstractCategory.Traveling.class), @XmlElement(name="undefined", type=AbstractCategory.Undefined.class), @XmlElement(name="working", type=AbstractCategory.Working.class)})
    private final AbstractCategory category;
    private final String text;

    public Activity() {
        this.category = null;
        this.text = null;
    }

    public Activity(Category category) {
        this(category, null, null);
    }

    public Activity(Category category, String text) {
        this(category, null, text);
    }

    public Activity(Category category, SpecificActivity specificActivity) {
        this(category, specificActivity, null);
    }

    public Activity(Category category, SpecificActivity specificActivity, String text) {
        try {
            this.category = category.categoryClass.getDeclaredConstructor(SpecificActivity.class).newInstance(specificActivity);
            this.text = text;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public final String getText() {
        return this.text;
    }

    public final Category getCategory() {
        return this.category != null ? this.category.category : null;
    }

    public final SpecificActivity getSpecificActivity() {
        return this.category != null ? this.category.specificActivity : null;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.category != null) {
            sb.append(this.category);
            if (this.category.specificActivity != null) {
                sb.append(" / ").append(this.category.specificActivity);
            }
            if (this.text != null) {
                sb.append(" (").append(this.text).append(')');
            }
            return sb.toString();
        }
        return super.toString();
    }

    @XmlTransient
    static abstract class AbstractCategory {
        @XmlTransient
        private final Category category;
        @XmlElementRef
        private final SpecificActivity specificActivity;

        private AbstractCategory() {
            this((Category)null, (SpecificActivity)null);
        }

        private AbstractCategory(Category category) {
            this(category, (SpecificActivity)null);
        }

        private AbstractCategory(Category category, SpecificActivity specificActivity) {
            this.category = category;
            this.specificActivity = specificActivity;
        }

        public final String toString() {
            return this.getClass().getSimpleName().replaceAll("([a-z])([A-Z]+)", "$1_$2").toLowerCase();
        }

        static final class Working
        extends AbstractCategory {
            Working() {
                super(Category.WORKING);
            }

            Working(SpecificActivity specificActivity) {
                super(Category.WORKING, specificActivity);
            }
        }

        static final class Undefined
        extends AbstractCategory {
            Undefined() {
                super(Category.UNDEFINED);
            }

            Undefined(SpecificActivity specificActivity) {
                super(Category.UNDEFINED, specificActivity);
            }
        }

        static final class Traveling
        extends AbstractCategory {
            Traveling() {
                super(Category.TRAVELING);
            }

            Traveling(SpecificActivity specificActivity) {
                super(Category.TRAVELING, specificActivity);
            }
        }

        static final class Talking
        extends AbstractCategory {
            Talking() {
                super(Category.TALKING);
            }

            Talking(SpecificActivity specificActivity) {
                super(Category.TALKING, specificActivity);
            }
        }

        static final class Relaxing
        extends AbstractCategory {
            Relaxing() {
                super(Category.RELAXING);
            }

            Relaxing(SpecificActivity specificActivity) {
                super(Category.RELAXING, specificActivity);
            }
        }

        static final class Inactive
        extends AbstractCategory {
            Inactive() {
                super(Category.INACTIVE);
            }

            Inactive(SpecificActivity specificActivity) {
                super(Category.INACTIVE, specificActivity);
            }
        }

        static final class HavingAppointment
        extends AbstractCategory {
            HavingAppointment() {
                super(Category.HAVING_APPOINTMENT);
            }

            HavingAppointment(SpecificActivity specificActivity) {
                super(Category.HAVING_APPOINTMENT, specificActivity);
            }
        }

        static final class Grooming
        extends AbstractCategory {
            Grooming() {
                super(Category.GROOMING);
            }

            Grooming(SpecificActivity specificActivity) {
                super(Category.GROOMING, specificActivity);
            }
        }

        static final class Exercising
        extends AbstractCategory {
            Exercising() {
                super(Category.EXERCISING);
            }

            Exercising(SpecificActivity specificActivity) {
                super(Category.EXERCISING, specificActivity);
            }
        }

        static final class Eating
        extends AbstractCategory {
            Eating() {
                super(Category.EATING);
            }

            Eating(SpecificActivity specificActivity) {
                super(Category.EATING, specificActivity);
            }
        }

        static final class Drinking
        extends AbstractCategory {
            Drinking() {
                super(Category.DRINKING);
            }

            Drinking(SpecificActivity specificActivity) {
                super(Category.DRINKING, specificActivity);
            }
        }

        static final class DoingChores
        extends AbstractCategory {
            DoingChores() {
                super(Category.DOING_CHORES);
            }

            DoingChores(SpecificActivity specificActivity) {
                super(Category.DOING_CHORES, specificActivity);
            }
        }
    }
}

