/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.amp.model;

import java.time.Instant;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;

public final class Rule {
    @XmlAttribute
    private final Action action;
    @XmlAttribute
    private final Condition condition;
    @XmlAttribute
    private final String value;

    private Rule() {
        this.action = null;
        this.condition = null;
        this.value = null;
    }

    private Rule(Action action, Condition condition, String value) {
        this.action = Objects.requireNonNull(action);
        this.condition = Objects.requireNonNull(condition);
        this.value = Objects.requireNonNull(value);
    }

    public static Rule of(Action action, Condition condition, String value) {
        return new Rule(action, condition, value);
    }

    public static Rule expireAt(Action action, Instant instant) {
        return new Rule(action, Condition.EXPIRE_AT, instant.toString());
    }

    public static Rule deliver(Action action, DeliveryMode value) {
        return new Rule(action, Condition.DELIVER, value.name().toLowerCase());
    }

    public static Rule matchResource(Action action, MatchResource value) {
        return new Rule(action, Condition.MATCH_RESOURCE, value.name().toLowerCase());
    }

    public final Action getAction() {
        return this.action;
    }

    public final Condition getCondition() {
        return this.condition;
    }

    public final String getValue() {
        return this.value;
    }

    public static enum MatchResource {
        ANY,
        EXACT,
        OTHER;

    }

    public static enum DeliveryMode {
        DIRECT,
        FORWARD,
        GATEWAY,
        NONE,
        STORED;

    }

    public static enum Condition {
        DELIVER,
        EXPIRE_AT,
        MATCH_RESOURCE;

    }

    public static enum Action {
        ALERT,
        DROP,
        ERROR,
        NOTIFY;

    }
}

