/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bob.model;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import rocks.xmpp.util.XmppUtils;

@XmlRootElement
public final class Data {
    public static final String NAMESPACE = "urn:xmpp:bob";
    @XmlAttribute
    private final String cid;
    @XmlAttribute(name="max-age")
    private final Integer maxAge;
    @XmlAttribute
    private final String type;
    @XmlValue
    private final byte[] bytes;

    private Data() {
        this.bytes = null;
        this.cid = null;
        this.type = null;
        this.maxAge = null;
    }

    public Data(String cid) {
        this.bytes = null;
        this.cid = Objects.requireNonNull(cid);
        this.type = null;
        this.maxAge = null;
    }

    public Data(byte[] bytes, String type) {
        this(bytes, type, null);
    }

    public Data(byte[] bytes, String type, Integer maxAge) {
        this.bytes = Objects.requireNonNull(bytes);
        this.cid = Data.createContendId(bytes);
        this.type = Objects.requireNonNull(type);
        this.maxAge = maxAge;
    }

    public static String createContendId(byte[] data) {
        return "sha1+" + XmppUtils.hash((byte[])data) + "@bob.xmpp.org";
    }

    public final String getContentId() {
        return this.cid;
    }

    public final Integer getMaxAge() {
        return this.maxAge;
    }

    public final String getType() {
        return this.type;
    }

    public final byte[] getBytes() {
        return this.bytes;
    }
}

