/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.delay.model;

import java.time.Instant;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.util.adapters.InstantAdapter;

@XmlRootElement(name="delay")
public final class DelayedDelivery {
    public static final String NAMESPACE = "urn:xmpp:delay";
    @XmlAttribute
    private final Jid from;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=InstantAdapter.class)
    private final Instant stamp;
    @XmlValue
    private final String reason;

    private DelayedDelivery() {
        this.stamp = null;
        this.from = null;
        this.reason = null;
    }

    public DelayedDelivery(Instant timestamp) {
        this(timestamp, null, null);
    }

    public DelayedDelivery(Instant timestamp, Jid from, String reason) {
        this.stamp = Objects.requireNonNull(timestamp);
        this.from = from;
        this.reason = reason;
    }

    public static Instant sendDate(Stanza stanza) {
        DelayedDelivery delayedDelivery = (DelayedDelivery)stanza.getExtension(DelayedDelivery.class);
        if (delayedDelivery != null) {
            return delayedDelivery.getTimeStamp();
        }
        return Instant.now();
    }

    public final Jid getFrom() {
        return this.from;
    }

    public final Instant getTimeStamp() {
        return this.stamp;
    }

    public final String getReason() {
        return this.reason;
    }

    public final String toString() {
        return "Send date: " + this.stamp;
    }
}

