/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.commands.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlValue;

@XmlRootElement
@XmlSeeAlso(value={MalformedAction.class, BadAction.class, BadLocale.class, BadPayload.class, BadSessionId.class, SessionExpired.class})
public final class Command {
    public static final String NAMESPACE = "http://jabber.org/protocol/commands";
    @XmlAttribute
    private final Action action;
    @XmlAttribute
    private final String node;
    @XmlAttribute
    private final String sessionid;
    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    private final Locale lang;
    @XmlAttribute
    private final Status status;
    private final Actions actions;
    private final List<Note> note = new ArrayList<Note>();
    @XmlAnyElement(lax=true)
    private final List<Object> payloads = new ArrayList<Object>();

    private Command() {
        this.action = null;
        this.node = null;
        this.sessionid = null;
        this.status = null;
        this.actions = null;
        this.lang = null;
    }

    public Command(String node, Action action) {
        this(node, null, action, null);
    }

    public Command(String node, String sessionId, Action action, List<Object> payloads) {
        this(node, sessionId, action, payloads, null, null);
    }

    public Command(String node, String sessionId, Action action, List<Object> payloads, Locale language, List<Note> notes) {
        this(node, sessionId, action, null, null, null, payloads, language, notes);
    }

    public Command(String node, String sessionId, Status status, Collection<Action> actions, Action defaultAction, List<Object> payloads) {
        this(node, sessionId, status, actions, defaultAction, payloads, null, null);
    }

    public Command(String node, String sessionId, Status status, Collection<Action> actions, Action defaultAction, List<Object> payloads, Locale language, List<Note> notes) {
        this(node, sessionId, null, status, actions, defaultAction, payloads, language, notes);
    }

    private Command(String node, String sessionId, Action action, Status status, Collection<Action> actions, Action defaultAction, List<Object> payloads, Locale language, List<Note> notes) {
        this.node = Objects.requireNonNull(node);
        this.sessionid = sessionId;
        this.action = action;
        this.status = status;
        if (payloads != null) {
            this.payloads.addAll(payloads);
        }
        if (notes != null) {
            this.note.addAll(notes);
        }
        this.actions = actions != null ? new Actions(actions.contains((Object)Action.PREV) ? "" : null, actions.contains((Object)Action.NEXT) ? "" : null, actions.contains((Object)Action.COMPLETE) ? "" : null, defaultAction) : null;
        this.lang = language;
    }

    public final List<Object> getPayloads() {
        return this.payloads;
    }

    public final Action getAction() {
        return this.action;
    }

    public final String getNode() {
        return this.node;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getSessionId() {
        return this.sessionid;
    }

    public final Collection<Action> getActions() {
        if (this.status == Status.COMPLETED) {
            return Collections.emptyList();
        }
        ArrayList<Action> possibleActions = new ArrayList<Action>();
        possibleActions.add(Action.CANCEL);
        possibleActions.add(Action.EXECUTE);
        if (this.actions == null) {
            possibleActions.add(Action.COMPLETE);
        } else {
            if (this.actions.prev != null) {
                possibleActions.add(Action.PREV);
            }
            if (this.actions.next != null) {
                possibleActions.add(Action.NEXT);
            }
            if (this.actions.complete != null) {
                possibleActions.add(Action.COMPLETE);
            }
        }
        return Collections.unmodifiableList(possibleActions);
    }

    public final Action getDefaultAction() {
        return this.actions != null ? this.actions.defaultAction : null;
    }

    public final List<Note> getNotes() {
        return this.note;
    }

    public final Locale getLanguage() {
        return this.lang;
    }

    public static final class Note {
        @XmlValue
        private final String value;
        @XmlAttribute
        private final Type type;

        private Note() {
            this.value = null;
            this.type = null;
        }

        public Note(Type type, String value) {
            this.type = Objects.requireNonNull(type);
            this.value = value;
        }

        public final Type getType() {
            return this.type;
        }

        public final String getValue() {
            return this.value;
        }

        public static enum Type {
            ERROR,
            INFO,
            WARN;

        }
    }

    @XmlRootElement(name="session-expired")
    public static final class SessionExpired {
    }

    @XmlRootElement(name="bad-sessionid")
    public static final class BadSessionId {
    }

    @XmlRootElement(name="bad-payload")
    public static final class BadPayload {
    }

    @XmlRootElement(name="bad-locale")
    public static final class BadLocale {
    }

    @XmlRootElement(name="bad-action")
    public static final class BadAction {
    }

    @XmlRootElement(name="malformed-action")
    public static final class MalformedAction {
    }

    private static final class Actions {
        private final String prev;
        private final String next;
        private final String complete;
        @XmlAttribute(name="execute")
        private final Action defaultAction;

        private Actions() {
            this(null, null, null, null);
        }

        private Actions(String prev, String next, String complete, Action defaultAction) {
            this.prev = prev;
            this.next = next;
            this.complete = complete;
            this.defaultAction = defaultAction;
        }
    }

    public static enum Status {
        CANCELED,
        COMPLETED,
        EXECUTING;

    }

    public static enum Action {
        CANCEL,
        COMPLETE,
        EXECUTE,
        NEXT,
        PREV;

    }
}

