/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.address.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import rocks.xmpp.addr.Jid;

public final class Address {
    public static final String NAMESPACE = "http://jabber.org/protocol/address";
    @XmlAttribute
    private final Type type;
    @XmlAttribute
    private final Jid jid;
    @XmlAttribute
    private final String desc;
    @XmlAttribute
    private final String node;
    @XmlAttribute
    private final URI uri;
    @XmlAnyElement(lax=true)
    private final List<Object> extensions = new ArrayList<Object>();

    private Address() {
        this.type = null;
        this.jid = null;
        this.desc = null;
        this.node = null;
        this.uri = null;
    }

    public Address(Type type, Jid jid, Object ... extensions) {
        this(type, jid, null, extensions);
    }

    public Address(Type type, Jid jid, CharSequence description, Object ... extensions) {
        this(type, jid, description, null, extensions);
    }

    public Address(Type type, Jid jid, CharSequence description, CharSequence node, Object ... extensions) {
        this.type = Objects.requireNonNull(type);
        this.jid = jid;
        this.desc = description != null ? description.toString() : null;
        this.node = node != null ? node.toString() : null;
        this.uri = null;
        this.extensions.addAll(Arrays.asList(extensions));
    }

    public Address(Type type, URI uri, CharSequence description, Object ... extensions) {
        this.type = Objects.requireNonNull(type);
        this.jid = null;
        this.uri = uri;
        this.desc = description != null ? description.toString() : null;
        this.node = null;
        this.extensions.addAll(Arrays.asList(extensions));
    }

    public final Type getType() {
        return this.type;
    }

    public final Jid getJid() {
        return this.jid;
    }

    public final String getDescription() {
        return this.desc;
    }

    public final String getNode() {
        return this.node;
    }

    public final URI getUri() {
        return this.uri;
    }

    public final List<Object> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public final <T> T getExtension(Class<T> clazz) {
        for (Object extension : this.extensions) {
            if (!clazz.isAssignableFrom(extension.getClass())) continue;
            return (T)extension;
        }
        return null;
    }

    public static enum Type {
        BCC,
        CC,
        NOREPLY,
        REPLYROOM,
        REPLYTO,
        TO,
        OFROM;

    }
}

