/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc.model.user;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.muc.model.Actor;
import rocks.xmpp.extensions.muc.model.Affiliation;
import rocks.xmpp.extensions.muc.model.Destroy;
import rocks.xmpp.extensions.muc.model.Item;
import rocks.xmpp.extensions.muc.model.Role;
import rocks.xmpp.extensions.muc.model.user.Decline;
import rocks.xmpp.extensions.muc.model.user.Invite;
import rocks.xmpp.extensions.muc.model.user.Status;

@XmlRootElement(name="x")
public final class MucUser {
    private final List<Status> status = new ArrayList<Status>();
    private final List<Invite> invite = new ArrayList<Invite>();
    private MucUserItem item;
    private Decline decline;
    private MucUserDestroy destroy;
    private String password;

    private MucUser() {
    }

    private MucUser(String password, Invite ... invite) {
        this.invite.addAll(Arrays.asList(invite));
        this.password = password;
    }

    private MucUser(Decline decline) {
        this.decline = decline;
    }

    private MucUser(MucUserItem item, Status ... status) {
        this.item = item;
        this.status.addAll(Arrays.asList(status));
    }

    private MucUser(MucUserItem item, MucUserDestroy destroy) {
        this.item = item;
        this.destroy = destroy;
    }

    public static MucUser withItem(Affiliation affiliation, Role role, Status ... status) {
        return new MucUser(new MucUserItem(affiliation, role, null, null, null, null), status);
    }

    public static MucUser withItem(Affiliation affiliation, Role role, Jid jid, Status ... status) {
        return new MucUser(new MucUserItem(affiliation, role, jid, null, null, null), status);
    }

    public static MucUser withItem(Affiliation affiliation, Role role, Jid jid, String nick, Status ... status) {
        return new MucUser(new MucUserItem(affiliation, role, jid, nick, null, null), status);
    }

    public static MucUser withItem(Role role, String nick, String reason, Status ... status) {
        return new MucUser(new MucUserItem(null, role, null, nick, null, reason), status);
    }

    public static MucUser withItem(Affiliation affiliation, Role role, Actor actor, String reason, Status ... status) {
        return new MucUser(new MucUserItem(affiliation, role, null, null, actor, reason), status);
    }

    public static MucUser withItem(Affiliation affiliation, Role role, String nick, String reason) {
        return new MucUser(new MucUserItem(affiliation, role, null, nick, null, reason), new Status[0]);
    }

    public static MucUser withItem(Affiliation affiliation, Role role, Jid jid, String nick, Actor actor, String reason, Status ... status) {
        return new MucUser(new MucUserItem(affiliation, role, jid, nick, actor, reason), status);
    }

    public static MucUser withDestroy(Affiliation affiliation, Role role, Jid jid, String reason) {
        return new MucUser(new MucUserItem(affiliation, role, null, null, null, null), new MucUserDestroy(jid, reason));
    }

    public static MucUser withInvites(Invite ... invite) {
        return new MucUser(null, invite);
    }

    public static MucUser withInvite(String password, Invite ... invite) {
        return new MucUser(password, invite);
    }

    public static MucUser withDecline(Jid to, String reason) {
        return new MucUser(new Decline(to, reason));
    }

    public static MucUser withStatus(Status ... status) {
        return new MucUser(null, status);
    }

    public List<Status> getStatusCodes() {
        return Collections.unmodifiableList(this.status);
    }

    public Item getItem() {
        return this.item;
    }

    public List<Invite> getInvites() {
        return Collections.unmodifiableList(this.invite);
    }

    public Decline getDecline() {
        return this.decline;
    }

    public Destroy getDestroy() {
        return this.destroy;
    }

    public String getPassword() {
        return this.password;
    }

    private static final class MucUserActor
    implements Actor {
        @XmlAttribute
        private Jid jid;
        @XmlAttribute
        private String nick;

        private MucUserActor() {
        }

        private MucUserActor(Actor actor) {
            this.jid = actor.getJid();
            this.nick = actor.getNick();
        }

        @Override
        public String getNick() {
            return this.nick;
        }

        @Override
        public Jid getJid() {
            return this.jid;
        }
    }

    private static final class MucUserDestroy
    implements Destroy {
        private String reason;
        @XmlAttribute
        private Jid jid;

        private MucUserDestroy() {
        }

        private MucUserDestroy(Jid jid, String reason) {
            this.jid = jid;
            this.reason = reason;
        }

        @Override
        public Jid getJid() {
            return this.jid;
        }

        @Override
        public String getReason() {
            return this.reason;
        }
    }

    private static final class MucUserItem
    implements Item {
        private MucUserActor actor;
        private String reason;
        @XmlAttribute
        private Affiliation affiliation;
        @XmlAttribute
        private Jid jid;
        @XmlAttribute
        private String nick;
        @XmlAttribute
        private Role role;

        private MucUserItem() {
        }

        private MucUserItem(Affiliation affiliation, Role role, Jid jid, String nick, Actor actor, String reason) {
            this.affiliation = affiliation;
            this.role = role;
            this.jid = jid;
            this.nick = nick;
            this.actor = actor != null ? new MucUserActor(actor) : null;
            this.reason = reason;
        }

        @Override
        public String getNick() {
            return this.nick;
        }

        @Override
        public Role getRole() {
            return this.role;
        }

        @Override
        public Jid getJid() {
            return this.jid;
        }

        @Override
        public Affiliation getAffiliation() {
            return this.affiliation;
        }

        @Override
        public String getReason() {
            return this.reason;
        }

        @Override
        public Actor getActor() {
            return this.actor;
        }
    }
}

