/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.nio.codec;

import com.fasterxml.aalto.AsyncByteBufferFeeder;
import com.fasterxml.aalto.AsyncXMLInputFactory;
import com.fasterxml.aalto.AsyncXMLStreamReader;
import com.fasterxml.aalto.stax.InputFactoryImpl;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.StreamErrorException;
import rocks.xmpp.core.stream.model.StreamHeader;
import rocks.xmpp.core.stream.model.errors.Condition;

public final class XmppStreamDecoder {
    private static final AsyncXMLInputFactory XML_INPUT_FACTORY = new InputFactoryImpl();
    private final Supplier<Unmarshaller> unmarshaller;
    private final StringBuilder xmlStream = new StringBuilder();
    private AsyncXMLStreamReader<AsyncByteBufferFeeder> xmlStreamReader;
    private String streamHeader;
    private long elementEnd;

    public XmppStreamDecoder(Supplier<Unmarshaller> unmarshaller) {
        this.unmarshaller = unmarshaller;
        this.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void decode(ByteBuffer in, BiConsumer<String, StreamElement> out) throws StreamErrorException {
        this.xmlStream.append(StandardCharsets.UTF_8.decode(in));
        in.rewind();
        try {
            int type;
            ((AsyncByteBufferFeeder)this.xmlStreamReader.getInputFeeder()).feedInput(in);
            block24: while ((type = this.xmlStreamReader.next()) != 8 && type != 257) {
                switch (type) {
                    case 1: {
                        if (this.xmlStreamReader.getDepth() != 1) continue block24;
                        String namespaceUri = this.xmlStreamReader.getNamespaceURI();
                        if (!"http://etherx.jabber.org/streams".equals(namespaceUri)) {
                            throw new StreamErrorException(new StreamError(Condition.INVALID_NAMESPACE, "Invalid stream namespace '" + namespaceUri + "'", Locale.US));
                        }
                        String localName = this.xmlStreamReader.getLocalName();
                        if (!"stream".equals(localName)) {
                            throw new StreamErrorException(new StreamError(Condition.INVALID_XML, "Invalid stream element '" + localName + "'", Locale.US));
                        }
                        String version = this.xmlStreamReader.getAttributeValue("", "version");
                        String from = this.xmlStreamReader.getAttributeValue("", "from");
                        String to = this.xmlStreamReader.getAttributeValue("", "to");
                        String id = this.xmlStreamReader.getAttributeValue("", "id");
                        String lang = this.xmlStreamReader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
                        String contentNamespace = this.xmlStreamReader.getNamespaceURI("");
                        ArrayList<QName> additionalNamespaces = new ArrayList<QName>();
                        int namespaceCount = this.xmlStreamReader.getNamespaceCount();
                        if (namespaceCount > 2) {
                            for (int i = 0; i < namespaceCount; ++i) {
                                String namespace = this.xmlStreamReader.getNamespaceURI(i);
                                if ("http://etherx.jabber.org/streams".equals(namespace) || Objects.equals(namespace, contentNamespace)) continue;
                                additionalNamespaces.add(new QName(namespace, "", this.xmlStreamReader.getNamespacePrefix(i)));
                            }
                        }
                        this.elementEnd = this.xmlStreamReader.getLocationInfo().getEndingByteOffset();
                        this.streamHeader = this.xmlStream.substring(0, (int)this.elementEnd);
                        this.xmlStream.delete(0, (int)this.elementEnd);
                        StreamHeader header = StreamHeader.create((Jid)(from != null ? Jid.ofEscaped((CharSequence)from) : null), (Jid)(to != null ? Jid.ofEscaped((CharSequence)to) : null), (String)id, (String)version, (Locale)(lang != null ? Locale.forLanguageTag(lang) : null), (String)contentNamespace, (QName[])additionalNamespaces.toArray(new QName[additionalNamespaces.size()]));
                        out.accept(this.streamHeader, (StreamElement)header);
                        continue block24;
                    }
                    case 2: {
                        if (this.xmlStreamReader.getDepth() >= 3) continue block24;
                        if (this.xmlStreamReader.getDepth() == 1) {
                            out.accept(this.xmlStream.toString().trim(), StreamHeader.CLOSING_STREAM_TAG);
                            continue block24;
                        }
                        long end = this.xmlStreamReader.getLocationInfo().getEndingByteOffset();
                        int elementLength = (int)(end - this.elementEnd);
                        this.elementEnd = end;
                        byte[] bytes = this.xmlStream.toString().getBytes(StandardCharsets.UTF_8);
                        String element = new String(bytes, 0, elementLength, StandardCharsets.UTF_8);
                        this.xmlStream.delete(0, element.length());
                        String partialStream = this.streamHeader + element + ' ';
                        XMLStreamReader reader = null;
                        try {
                            StringReader stringReader = new StringReader(partialStream);
                            Throwable throwable = null;
                            try {
                                reader = XML_INPUT_FACTORY.createXMLStreamReader((Reader)stringReader);
                                reader.next();
                                int t = reader.next();
                                while (reader.hasNext() && t != 1) {
                                    t = reader.next();
                                }
                                out.accept(element, (StreamElement)this.unmarshaller.get().unmarshal(reader));
                                continue block24;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (throwable != null) {
                                    try {
                                        ((Reader)stringReader).close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue block24;
                                }
                                ((Reader)stringReader).close();
                                continue block24;
                            }
                        }
                        finally {
                            if (reader == null) continue block24;
                            reader.close();
                            continue block24;
                        }
                    }
                    case 3: 
                    case 5: 
                    case 9: 
                    case 11: 
                    case 14: 
                    case 15: {
                        throw new StreamErrorException(new StreamError(Condition.RESTRICTED_XML));
                    }
                }
            }
        }
        catch (StreamErrorException e) {
            throw e;
        }
        catch (XMLStreamException e) {
            throw new StreamErrorException(new StreamError(Condition.NOT_WELL_FORMED), (Throwable)e);
        }
        catch (Exception e) {
            throw new StreamErrorException(new StreamError(Condition.INTERNAL_SERVER_ERROR), (Throwable)e);
        }
        finally {
            this.xmlStream.trimToSize();
            in.position(in.limit());
        }
    }

    public final synchronized void restart() {
        this.xmlStream.setLength(0);
        this.xmlStreamReader = XML_INPUT_FACTORY.createAsyncForByteBuffer();
        this.elementEnd = 0L;
    }
}

