/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.nio.codec;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.StreamErrorException;
import rocks.xmpp.core.stream.model.StreamHeader;
import rocks.xmpp.core.stream.model.errors.Condition;
import rocks.xmpp.nio.codec.ByteBufferOutputStream;
import rocks.xmpp.util.XmppUtils;

public final class XmppStreamEncoder {
    private final XMLOutputFactory outputFactory;
    private final Supplier<Marshaller> marshaller;
    private final Function<StreamElement, StreamElement> stanzaMapper;
    private String contentNamespace;

    public XmppStreamEncoder(XMLOutputFactory outputFactory, Supplier<Marshaller> marshaller, Function<StreamElement, StreamElement> stanzaMapper) {
        this.marshaller = marshaller;
        this.stanzaMapper = stanzaMapper;
        this.outputFactory = outputFactory;
    }

    public final ByteBuffer encode(StreamElement streamElement) throws StreamErrorException {
        try (ByteBufferOutputStream outputStream = new ByteBufferOutputStream(512, false);){
            this.encode(streamElement, outputStream);
            ByteBuffer byteBuffer = (ByteBuffer)outputStream.getBuffer().flip();
            return byteBuffer;
        }
    }

    public final void encode(StreamElement streamElement, OutputStream outputStream) throws StreamErrorException {
        try {
            if (streamElement instanceof StreamHeader) {
                this.contentNamespace = ((StreamHeader)streamElement).getContentNamespace();
                XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter(outputStream, StandardCharsets.UTF_8.name());
                ((StreamHeader)streamElement).writeTo(writer);
                return;
            }
            if (streamElement == StreamHeader.CLOSING_STREAM_TAG) {
                outputStream.write(StreamHeader.CLOSING_STREAM_TAG.toString().getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
                return;
            }
            streamElement = this.stanzaMapper.apply(streamElement);
            XMLStreamWriter streamWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)this.outputFactory.createXMLStreamWriter(outputStream, StandardCharsets.UTF_8.name()));
            streamWriter.setDefaultNamespace(this.contentNamespace);
            Marshaller m = this.marshaller.get();
            m.setProperty("jaxb.fragment", (Object)true);
            m.marshal((Object)streamElement, streamWriter);
            streamWriter.flush();
        }
        catch (IOException | JAXBException | XMLStreamException e) {
            throw new StreamErrorException(new StreamError(Condition.INTERNAL_SERVER_ERROR), e);
        }
    }
}

