/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.nio.codec;

import com.fasterxml.aalto.AsyncByteBufferFeeder;
import com.fasterxml.aalto.AsyncXMLInputFactory;
import com.fasterxml.aalto.AsyncXMLStreamReader;
import com.fasterxml.aalto.stax.InputFactoryImpl;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.net.ReaderInterceptor;
import rocks.xmpp.core.net.ReaderInterceptorChain;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.StreamErrorException;
import rocks.xmpp.core.stream.model.StreamHeader;
import rocks.xmpp.core.stream.model.errors.Condition;

public final class XmppStreamDecoder
implements ReaderInterceptor {
    private static final AsyncXMLInputFactory XML_INPUT_FACTORY = new InputFactoryImpl();
    private final Function<Locale, Unmarshaller> unmarshaller;
    private byte[] byteStream = new byte[0];
    private AsyncXMLStreamReader<AsyncByteBufferFeeder> xmlStreamReader;
    private StreamHeader streamHeader;
    private long elementEnd;
    private String element = "";
    private StreamElement streamElement;

    public XmppStreamDecoder(Function<Locale, Unmarshaller> unmarshaller) {
        this.unmarshaller = unmarshaller;
        this.restart();
    }

    private static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void decode(ByteBuffer in, BiConsumer<String, StreamElement> out) throws StreamErrorException {
        byte[] b = new byte[in.remaining()];
        in.get(b);
        this.byteStream = XmppStreamDecoder.concat(this.byteStream, b);
        in.rewind();
        try {
            int type;
            ((AsyncByteBufferFeeder)this.xmlStreamReader.getInputFeeder()).feedInput(in);
            block20: while ((type = this.xmlStreamReader.next()) != 8 && type != 257) {
                switch (type) {
                    case 1: {
                        if (this.xmlStreamReader.getDepth() != 1) continue block20;
                        String namespaceUri = this.xmlStreamReader.getNamespaceURI();
                        if (!"http://etherx.jabber.org/streams".equals(namespaceUri)) {
                            throw new StreamErrorException(new StreamError(Condition.INVALID_NAMESPACE, "Invalid stream namespace '" + namespaceUri + "'", Locale.US));
                        }
                        String localName = this.xmlStreamReader.getLocalName();
                        if (!"stream".equals(localName)) {
                            throw new StreamErrorException(new StreamError(Condition.INVALID_XML, "Invalid stream element '" + localName + "'", Locale.US));
                        }
                        String version = this.xmlStreamReader.getAttributeValue("", "version");
                        String from = this.xmlStreamReader.getAttributeValue("", "from");
                        String to = this.xmlStreamReader.getAttributeValue("", "to");
                        String id = this.xmlStreamReader.getAttributeValue("", "id");
                        String lang = this.xmlStreamReader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
                        String contentNamespace = this.xmlStreamReader.getNamespaceURI("");
                        ArrayList<QName> additionalNamespaces = new ArrayList<QName>();
                        int namespaceCount = this.xmlStreamReader.getNamespaceCount();
                        if (namespaceCount > 2) {
                            for (int i = 0; i < namespaceCount; ++i) {
                                String namespace = this.xmlStreamReader.getNamespaceURI(i);
                                if ("http://etherx.jabber.org/streams".equals(namespace) || Objects.equals(namespace, contentNamespace)) continue;
                                additionalNamespaces.add(new QName(namespace, "", this.xmlStreamReader.getNamespacePrefix(i)));
                            }
                        }
                        this.elementEnd = this.xmlStreamReader.getLocationInfo().getEndingByteOffset();
                        String streamHeaderStr = new String(this.byteStream, 0, (int)this.elementEnd, StandardCharsets.UTF_8);
                        this.byteStream = Arrays.copyOfRange(this.byteStream, (int)this.elementEnd, this.byteStream.length);
                        this.streamHeader = StreamHeader.create((Jid)(from != null ? Jid.ofEscaped((CharSequence)from) : null), (Jid)(to != null ? Jid.ofEscaped((CharSequence)to) : null), (String)id, (String)version, (Locale)(lang != null ? Locale.forLanguageTag(lang) : null), (String)contentNamespace, (QName[])additionalNamespaces.toArray(new QName[0]));
                        this.element = streamHeaderStr;
                        this.streamElement = this.streamHeader;
                        out.accept(streamHeaderStr, (StreamElement)this.streamHeader);
                        continue block20;
                    }
                    case 2: {
                        if (this.xmlStreamReader.getDepth() >= 3) continue block20;
                        long end = this.xmlStreamReader.getLocationInfo().getEndingByteOffset();
                        int elementLength = (int)(end - this.elementEnd);
                        this.elementEnd = end;
                        this.element = new String(this.byteStream, 0, elementLength, StandardCharsets.UTF_8);
                        if (this.xmlStreamReader.getDepth() == 1) {
                            this.streamElement = StreamHeader.CLOSING_STREAM_TAG;
                            out.accept(this.element, StreamHeader.CLOSING_STREAM_TAG);
                            continue block20;
                        }
                        this.byteStream = Arrays.copyOfRange(this.byteStream, elementLength, this.byteStream.length);
                        String partialStream = this.streamHeader + this.element + " ";
                        XMLStreamReader reader = null;
                        try {
                            StringReader stringReader = new StringReader(partialStream);
                            try {
                                reader = XML_INPUT_FACTORY.createXMLStreamReader((Reader)stringReader);
                                reader.next();
                                int t = reader.next();
                                while (reader.hasNext() && t != 1) {
                                    t = reader.next();
                                }
                                this.streamElement = (StreamElement)this.unmarshaller.apply(this.streamHeader.getLanguage()).unmarshal(reader);
                                out.accept(this.element, this.streamElement);
                                continue block20;
                            }
                            finally {
                                ((Reader)stringReader).close();
                                continue block20;
                            }
                        }
                        finally {
                            if (reader == null) continue block20;
                            reader.close();
                            continue block20;
                        }
                    }
                    case 3: 
                    case 5: 
                    case 9: 
                    case 11: 
                    case 14: 
                    case 15: {
                        throw new StreamErrorException(new StreamError(Condition.RESTRICTED_XML));
                    }
                }
            }
        }
        catch (StreamErrorException e) {
            throw e;
        }
        catch (XMLStreamException e) {
            throw new StreamErrorException(new StreamError(Condition.NOT_WELL_FORMED), (Throwable)e);
        }
        catch (Exception e) {
            throw new StreamErrorException(new StreamError(Condition.INTERNAL_SERVER_ERROR), (Throwable)e);
        }
        finally {
            in.position(in.limit());
        }
    }

    public final synchronized void restart() {
        this.byteStream = new byte[0];
        this.xmlStreamReader = XML_INPUT_FACTORY.createAsyncForByteBuffer();
        this.elementEnd = 0L;
    }

    public final synchronized void process(Reader reader, Consumer<StreamElement> streamElementListener, ReaderInterceptorChain chain) throws Exception {
        char[] chars = new char[this.element.length()];
        int n = reader.read(chars, 0, this.element.length());
        if (n > -1) {
            this.element = "";
            streamElementListener.accept(this.streamElement);
            chain.proceed(reader, streamElementListener);
        }
    }
}

