/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.nio.netty.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Locale;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import rocks.xmpp.core.net.ConnectionConfiguration;
import rocks.xmpp.core.net.TcpBinding;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamHandler;
import rocks.xmpp.core.stream.client.StreamFeaturesManager;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.StreamErrorException;
import rocks.xmpp.core.stream.model.errors.Condition;
import rocks.xmpp.core.tls.client.StartTlsManager;
import rocks.xmpp.extensions.compress.CompressionManager;
import rocks.xmpp.extensions.sm.StreamManager;
import rocks.xmpp.nio.netty.client.NettyTcpConnectionConfiguration;
import rocks.xmpp.nio.netty.net.NettyChannelConnection;

public final class NettyTcpConnection
extends NettyChannelConnection {
    private static final Logger logger = Logger.getLogger(NettyTcpConnection.class.getName());
    private final StreamFeaturesManager streamFeaturesManager;
    private final StreamManager streamManager;
    private final StartTlsManager startTlsManager;
    private final CompressionManager compressionManager;
    private final NettyTcpConnectionConfiguration connectionConfiguration;
    private final XmppSession xmppSession;

    NettyTcpConnection(Channel channel, XmppSession xmppSession, NettyTcpConnectionConfiguration connectionConfiguration) {
        super(channel, (StreamHandler)xmppSession, (arg_0, arg_1) -> ((XmppDebugger)xmppSession.getDebugger()).readStanza(arg_0, arg_1), () -> ((XmppSession)xmppSession).createUnmarshaller(), (arg_0, arg_1) -> ((XmppDebugger)xmppSession.getDebugger()).writeStanza(arg_0, arg_1), () -> ((XmppSession)xmppSession).createMarshaller(), arg_0 -> ((XmppSession)xmppSession).notifyException(arg_0), (ConnectionConfiguration)connectionConfiguration);
        this.xmppSession = xmppSession;
        this.connectionConfiguration = connectionConfiguration;
        this.closeFuture().whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                xmppSession.notifyException(throwable);
            } else if (!this.isClosed()) {
                xmppSession.notifyException((Throwable)new StreamErrorException(new StreamError(Condition.UNDEFINED_CONDITION, "Stream closed by server", Locale.ENGLISH, null)));
            }
        });
        this.streamManager = (StreamManager)xmppSession.getManager(StreamManager.class);
        this.streamManager.reset();
        this.startTlsManager = new StartTlsManager(xmppSession, (TcpBinding)this, connectionConfiguration.getChannelEncryption());
        this.compressionManager = new CompressionManager(xmppSession, (TcpBinding)this);
        this.compressionManager.getConfiguredCompressionMethods().clear();
        this.compressionManager.getConfiguredCompressionMethods().addAll(connectionConfiguration.getCompressionMethods());
        this.streamFeaturesManager = (StreamFeaturesManager)xmppSession.getManager(StreamFeaturesManager.class);
        this.streamFeaturesManager.addFeatureNegotiator((StreamFeatureNegotiator)this.streamManager);
        this.streamFeaturesManager.addFeatureNegotiator((StreamFeatureNegotiator)this.startTlsManager);
        this.streamFeaturesManager.addFeatureNegotiator((StreamFeatureNegotiator)this.compressionManager);
    }

    protected final void restartStream() {
        super.restartStream();
        this.open(this.sessionOpen);
    }

    public final void secureConnection() throws NoSuchAlgorithmException {
        SSLContext sslContext = this.getConfiguration().getSSLContext() != null ? this.getConfiguration().getSSLContext() : SSLContext.getDefault();
        JdkSslContext sslCtx = new JdkSslContext(sslContext, true, ClientAuth.OPTIONAL);
        SslHandler handler = sslCtx.newHandler(this.channel.alloc(), String.valueOf(this.xmppSession.getDomain()), this.connectionConfiguration.getPort());
        HostnameVerifier verifier = this.connectionConfiguration.getHostnameVerifier();
        SSLEngine sslEngine = handler.engine();
        if (verifier == null) {
            SSLParameters sslParameters = sslEngine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParameters);
        }
        Future handshakeFuture = handler.handshakeFuture();
        handshakeFuture.addListener(future -> {
            if (future.isSuccess()) {
                if (verifier != null && !verifier.verify(this.xmppSession.getDomain().toString(), sslEngine.getSession())) {
                    this.xmppSession.notifyException((Throwable)new CertificateException("Server failed to authenticate as " + this.xmppSession.getDomain()));
                } else {
                    logger.log(Level.FINE, "Connection has been secured via TLS.");
                }
            } else {
                this.xmppSession.notifyException(future.cause());
            }
        });
        this.channel.pipeline().addFirst("SSL", (ChannelHandler)handler);
    }

    public final boolean isUsingAcknowledgements() {
        return this.streamManager.isActive();
    }

    protected final CompletionStage<Void> closeConnection() {
        return super.closeConnection().thenRun(() -> {
            this.streamFeaturesManager.removeFeatureNegotiator((StreamFeatureNegotiator)this.streamManager);
            this.streamFeaturesManager.removeFeatureNegotiator((StreamFeatureNegotiator)this.startTlsManager);
            this.streamFeaturesManager.removeFeatureNegotiator((StreamFeatureNegotiator)this.compressionManager);
        });
    }
}

