/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.nio.netty.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import java.net.Proxy;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.client.TcpConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.nio.netty.client.NettyTcpConnection;

public final class NettyTcpConnectionConfiguration
extends TcpConnectionConfiguration<Channel> {
    private final EventLoopGroup eventLoopGroup;

    private NettyTcpConnectionConfiguration(Builder builder) {
        super((TcpConnectionConfiguration.Builder)builder);
        this.eventLoopGroup = builder.eventLoopGroup != null ? builder.eventLoopGroup : new NioEventLoopGroup();
    }

    public static Builder builder() {
        return new Builder();
    }

    public final Connection createConnection(XmppSession xmppSession) throws Exception {
        return this.createConnection(xmppSession, channel -> new NettyTcpConnection((Channel)channel, xmppSession, this));
    }

    protected Channel connect(String hostname, int port) throws Exception {
        Bootstrap b = new Bootstrap();
        b.group(this.getEventLoopGroup());
        b.channel(NioSocketChannel.class);
        b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.getConnectTimeout());
        b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public final void initChannel(SocketChannel ch) {
                Proxy proxy = NettyTcpConnectionConfiguration.this.getProxy();
                if (proxy != null) {
                    if (proxy.type() == Proxy.Type.SOCKS) {
                        ch.pipeline().addFirst(new ChannelHandler[]{new Socks5ProxyHandler(NettyTcpConnectionConfiguration.this.getProxy().address())});
                    } else if (proxy.type() == Proxy.Type.HTTP) {
                        ch.pipeline().addFirst(new ChannelHandler[]{new HttpProxyHandler(NettyTcpConnectionConfiguration.this.getProxy().address())});
                    }
                }
            }
        });
        ChannelFuture channelFuture = b.connect(hostname, port);
        channelFuture.get();
        return channelFuture.channel();
    }

    public final EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public final String toString() {
        return "Netty connection configuration: " + super.toString();
    }

    public static final class Builder
    extends TcpConnectionConfiguration.Builder<Builder> {
        private EventLoopGroup eventLoopGroup;

        public Builder eventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = eventLoopGroup;
            return this;
        }

        protected final Builder self() {
            return this;
        }

        public final NettyTcpConnectionConfiguration build() {
            return new NettyTcpConnectionConfiguration(this);
        }
    }
}

