/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.nio.netty.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import rocks.xmpp.core.Session;
import rocks.xmpp.core.net.ConnectionConfiguration;
import rocks.xmpp.core.net.TcpConnection;
import rocks.xmpp.core.net.client.TcpConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamHandler;
import rocks.xmpp.core.stream.client.StreamFeaturesManager;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.StreamErrorException;
import rocks.xmpp.core.stream.model.errors.Condition;
import rocks.xmpp.core.tls.client.StartTlsManager;
import rocks.xmpp.extensions.compress.CompressionManager;
import rocks.xmpp.extensions.sm.client.ClientStreamManager;
import rocks.xmpp.nio.netty.net.NettyChannelConnection;

final class NettyChannelClientConnection
extends NettyChannelConnection {
    private static final System.Logger logger = System.getLogger(NettyChannelClientConnection.class.getName());
    private final StreamFeaturesManager streamFeaturesManager;
    private final ClientStreamManager streamManager;
    private final StartTlsManager startTlsManager;
    private final CompressionManager compressionManager;
    private final TcpConnectionConfiguration connectionConfiguration;
    private final XmppSession xmppSession;

    NettyChannelClientConnection(Channel channel, XmppSession xmppSession, TcpConnectionConfiguration connectionConfiguration) {
        super(channel, (StreamHandler)xmppSession, (Session)xmppSession, xmppSession.getReaderInterceptors(), arg_0 -> ((XmppSession)xmppSession).createUnmarshaller(arg_0), xmppSession.getWriterInterceptors(), () -> ((XmppSession)xmppSession).createMarshaller(), arg_0 -> ((XmppSession)xmppSession).notifyException(arg_0), (ConnectionConfiguration)connectionConfiguration);
        this.xmppSession = xmppSession;
        this.connectionConfiguration = connectionConfiguration;
        Duration keepAliveInterval = connectionConfiguration.getKeepAliveInterval();
        if (keepAliveInterval != null && !keepAliveInterval.isNegative() && !keepAliveInterval.isZero()) {
            channel.pipeline().addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(0L, keepAliveInterval.toSeconds(), 0L, TimeUnit.SECONDS));
            channel.pipeline().addLast("idleStateEventHandler", (ChannelHandler)new ChannelDuplexHandler(){

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                    if (evt instanceof IdleStateEvent) {
                        ctx.writeAndFlush((Object)Character.valueOf(' '));
                    }
                }
            });
        }
        this.closeFuture().whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                xmppSession.notifyException(throwable);
            } else if (!this.isClosed()) {
                xmppSession.notifyException((Throwable)new StreamErrorException(new StreamError(Condition.UNDEFINED_CONDITION, "Stream closed by server", Locale.ENGLISH, null)));
            }
        });
        this.streamManager = (ClientStreamManager)xmppSession.getManager(ClientStreamManager.class);
        this.startTlsManager = new StartTlsManager((Session)xmppSession, (TcpConnection)this, connectionConfiguration.getChannelEncryption());
        this.compressionManager = new CompressionManager((Session)xmppSession, (TcpConnection)this);
        this.compressionManager.getConfiguredCompressionMethods().clear();
        this.compressionManager.getConfiguredCompressionMethods().addAll(connectionConfiguration.getCompressionMethods());
        this.streamFeaturesManager = (StreamFeaturesManager)xmppSession.getManager(StreamFeaturesManager.class);
        this.streamFeaturesManager.addFeatureNegotiator((StreamFeatureNegotiator)this.startTlsManager);
        this.streamFeaturesManager.addFeatureNegotiator((StreamFeatureNegotiator)this.compressionManager);
    }

    protected final void restartStream() {
        super.restartStream();
        this.open(this.sessionOpen);
    }

    public final void secureConnection() throws NoSuchAlgorithmException {
        SSLContext sslContext = this.getConfiguration().getSSLContext() != null ? this.getConfiguration().getSSLContext() : SSLContext.getDefault();
        JdkSslContext sslCtx = new JdkSslContext(sslContext, true, ClientAuth.OPTIONAL);
        SslHandler handler = sslCtx.newHandler(this.channel.alloc(), String.valueOf(this.xmppSession.getDomain()), this.connectionConfiguration.getPort());
        HostnameVerifier verifier = this.connectionConfiguration.getHostnameVerifier();
        SSLEngine sslEngine = handler.engine();
        if (verifier == null) {
            SSLParameters sslParameters = sslEngine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParameters);
        }
        Future handshakeFuture = handler.handshakeFuture();
        handshakeFuture.addListener(future -> {
            if (future.isSuccess()) {
                if (verifier != null && !verifier.verify(this.xmppSession.getDomain().toString(), sslEngine.getSession())) {
                    this.xmppSession.notifyException((Throwable)new CertificateException("Server failed to authenticate as " + this.xmppSession.getDomain()));
                } else {
                    logger.log(System.Logger.Level.DEBUG, "Connection has been secured via TLS.");
                }
            } else {
                this.xmppSession.notifyException(future.cause());
            }
        });
        this.channel.pipeline().addFirst("SSL", (ChannelHandler)handler);
    }

    public final boolean isUsingAcknowledgements() {
        return this.streamManager.isActive();
    }

    protected final CompletionStage<Void> closeStream() {
        this.streamFeaturesManager.removeFeatureNegotiator((StreamFeatureNegotiator)this.startTlsManager);
        this.streamFeaturesManager.removeFeatureNegotiator((StreamFeatureNegotiator)this.compressionManager);
        return super.closeStream();
    }
}

