/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.nio.netty.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.util.concurrent.Future;
import java.net.Proxy;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.client.AbstractTcpConnector;
import rocks.xmpp.core.net.client.TcpConnectionConfiguration;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.model.SessionOpen;
import rocks.xmpp.nio.netty.client.NettyChannelClientConnection;
import rocks.xmpp.nio.netty.net.NettyChannelConnection;

public final class NettyChannelConnector
extends AbstractTcpConnector<Channel> {
    private final EventLoopGroup eventLoopGroup;

    public NettyChannelConnector() {
        this((EventLoopGroup)new NioEventLoopGroup());
    }

    public NettyChannelConnector(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = Objects.requireNonNull(eventLoopGroup);
    }

    protected final CompletableFuture<Channel> connect(String hostname, int port, final TcpConnectionConfiguration configuration) {
        Bootstrap b = new Bootstrap();
        b.group(this.eventLoopGroup);
        b.channel(NioSocketChannel.class);
        b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)configuration.getConnectTimeout());
        b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public final void initChannel(SocketChannel ch) {
                Proxy proxy = configuration.getProxy();
                if (proxy != null) {
                    if (proxy.type() == Proxy.Type.SOCKS) {
                        ch.pipeline().addFirst(new ChannelHandler[]{new Socks5ProxyHandler(configuration.getProxy().address())});
                    } else if (proxy.type() == Proxy.Type.HTTP) {
                        ch.pipeline().addFirst(new ChannelHandler[]{new HttpProxyHandler(configuration.getProxy().address())});
                    }
                }
            }
        });
        ChannelFuture channelFuture = b.connect(hostname, port);
        return NettyChannelConnection.completableFutureFromNettyFuture((Future)channelFuture).thenApply(aVoid -> channelFuture.channel());
    }

    public final CompletableFuture<Connection> connect(XmppSession xmppSession, TcpConnectionConfiguration configuration, SessionOpen sessionOpen) {
        return this.createConnection(xmppSession, configuration, (channel, config) -> new NettyChannelClientConnection((Channel)channel, xmppSession, (TcpConnectionConfiguration)config), sessionOpen);
    }
}

