/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.nio.netty.net;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.compression.JdkZlibDecoder;
import io.netty.handler.codec.compression.JdkZlibEncoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.net.AbstractConnection;
import rocks.xmpp.core.net.ConnectionConfiguration;
import rocks.xmpp.core.net.TcpBinding;
import rocks.xmpp.core.session.model.SessionOpen;
import rocks.xmpp.core.stream.StreamHandler;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamHeader;
import rocks.xmpp.nio.netty.net.NettyXmppDecoder;
import rocks.xmpp.nio.netty.net.NettyXmppEncoder;

public class NettyChannelConnection
extends AbstractConnection
implements TcpBinding {
    protected final Channel channel;
    private final NettyXmppDecoder decoder;
    private final BiConsumer<String, StreamElement> onRead;
    protected SessionOpen sessionOpen;
    private final StreamHandler streamHandler;
    private final Consumer<Throwable> onException;

    public NettyChannelConnection(Channel channel, StreamHandler streamHandler, BiConsumer<String, StreamElement> onRead, Supplier<Unmarshaller> unmarshallerSupplier, BiConsumer<String, StreamElement> onWrite, Supplier<Marshaller> marshallerSupplier, Consumer<Throwable> onException, ConnectionConfiguration connectionConfiguration) {
        super(connectionConfiguration);
        this.channel = channel;
        this.onRead = onRead;
        this.streamHandler = streamHandler;
        this.onException = onException;
        this.decoder = new NettyXmppDecoder(this::onRead, unmarshallerSupplier, onException);
        channel.pipeline().addLast(new ChannelHandler[]{this.decoder, new NettyXmppEncoder(onWrite, marshallerSupplier, onException)});
    }

    private static <T> CompletableFuture<T> completableFutureFromNettyFuture(Future<T> future) {
        CompletableFuture completableFuture = new CompletableFuture();
        future.addListener(f -> {
            if (f.isSuccess()) {
                completableFuture.complete(future.getNow());
            } else {
                completableFuture.completeExceptionally(future.cause());
            }
        });
        return completableFuture;
    }

    private CompletionStage<Void> write(StreamElement streamElement, Function<StreamElement, ChannelFuture> writeFunction) {
        if (!this.isClosed() || streamElement == StreamHeader.CLOSING_STREAM_TAG) {
            return NettyChannelConnection.completableFutureFromNettyFuture((Future)writeFunction.apply(streamElement));
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        completableFuture.completeExceptionally(new IllegalStateException("Connection closed"));
        return completableFuture;
    }

    private void onRead(String xml, StreamElement streamElement) {
        if (this.onRead != null) {
            this.onRead.accept(xml, streamElement);
        }
        if (streamElement instanceof SessionOpen) {
            this.openedByPeer((SessionOpen)streamElement);
        } else if (streamElement == StreamHeader.CLOSING_STREAM_TAG) {
            this.closedByPeer();
        }
        try {
            if (this.streamHandler.handleElement((Object)streamElement)) {
                this.restartStream();
            }
        }
        catch (XmppException e) {
            this.onException.accept(e);
        }
    }

    public final InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    public final CompletionStage<Void> open(SessionOpen sessionOpen) {
        this.sessionOpen = sessionOpen;
        return this.send((StreamElement)sessionOpen);
    }

    public final CompletionStage<Void> send(StreamElement streamElement) {
        return this.write(streamElement, arg_0 -> ((Channel)this.channel).writeAndFlush(arg_0));
    }

    public final CompletionStage<Void> write(StreamElement streamElement) {
        return this.write(streamElement, arg_0 -> ((Channel)this.channel).write(arg_0));
    }

    public final void flush() {
        this.channel.flush();
    }

    public void secureConnection() throws Exception {
        SSLContext sslContext = this.getConfiguration().getSSLContext();
        JdkSslContext sslCtx = new JdkSslContext(sslContext, false, ClientAuth.NONE);
        SslHandler handler = new SslHandler(sslCtx.newEngine(this.channel.alloc()), true);
        this.channel.pipeline().addFirst("SSL", (ChannelHandler)handler);
    }

    public final void compressConnection(String method, Runnable onSuccess) {
        ChannelHandler channelHandler;
        ZlibWrapper zlibWrapper;
        switch (method) {
            case "zlib": {
                zlibWrapper = ZlibWrapper.ZLIB;
                break;
            }
            case "deflate": {
                zlibWrapper = ZlibWrapper.NONE;
                break;
            }
            case "gzip": {
                zlibWrapper = ZlibWrapper.GZIP;
                break;
            }
            default: {
                throw new IllegalArgumentException("Compression method '" + method + "' not supported");
            }
        }
        if (onSuccess != null) {
            onSuccess.run();
        }
        if ((channelHandler = this.channel.pipeline().get("SSL")) != null) {
            this.channel.pipeline().addAfter("SSL", "decompressor", (ChannelHandler)new JdkZlibDecoder(zlibWrapper));
            this.channel.pipeline().addAfter("SSL", "compressor", (ChannelHandler)new JdkZlibEncoder(zlibWrapper));
        } else {
            this.channel.pipeline().addFirst("decompressor", (ChannelHandler)new JdkZlibDecoder(zlibWrapper));
            this.channel.pipeline().addFirst("compressor", (ChannelHandler)new JdkZlibEncoder(zlibWrapper));
        }
    }

    public final boolean isSecure() {
        return this.channel.pipeline().toMap().containsKey("SSL");
    }

    protected void restartStream() {
        this.decoder.restart();
    }

    public final CompletionStage<Void> closeFuture() {
        return NettyChannelConnection.completableFutureFromNettyFuture(this.channel.closeFuture());
    }

    protected final CompletionStage<Void> closeStream() {
        return this.send(StreamHeader.CLOSING_STREAM_TAG);
    }

    protected CompletionStage<Void> closeConnection() {
        return NettyChannelConnection.completableFutureFromNettyFuture(this.channel.close());
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder("TCP NIO connection at ").append(this.channel.remoteAddress());
        String streamId = this.getStreamId();
        if (streamId != null) {
            sb.append(" (").append(streamId).append(')');
        }
        return sb.toString();
    }
}

