/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.nio.netty.net;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.bind.Unmarshaller;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.nio.codec.XmppStreamDecoder;

final class NettyXmppDecoder
extends ByteToMessageDecoder {
    private final BiConsumer<String, StreamElement> onRead;
    private final XmppStreamDecoder xmppStreamDecoder;
    private final Consumer<Throwable> onFailure;

    NettyXmppDecoder(BiConsumer<String, StreamElement> onRead, Supplier<Unmarshaller> unmarshallerSupplier, Consumer<Throwable> onFailure) {
        this.onRead = onRead;
        this.xmppStreamDecoder = new XmppStreamDecoder(unmarshallerSupplier);
        this.onFailure = onFailure;
    }

    protected final void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> list) throws Exception {
        ByteBuffer byteBuffer = byteBuf.nioBuffer();
        this.xmppStreamDecoder.decode(byteBuffer, (s, streamElement) -> {
            list.add(streamElement);
            if (this.onRead != null) {
                this.onRead.accept((String)s, (StreamElement)streamElement);
            }
        });
        byteBuf.readerIndex(byteBuffer.position());
    }

    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.onFailure != null) {
            this.onFailure.accept(cause);
        } else {
            super.exceptionCaught(ctx, cause);
        }
    }

    final void restart() {
        this.xmppStreamDecoder.restart();
    }
}

