/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.nio.netty.net;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLOutputFactory;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.nio.codec.XmppStreamEncoder;

final class NettyXmppEncoder
extends MessageToByteEncoder<StreamElement> {
    private final BiConsumer<String, StreamElement> onWrite;
    private final XmppStreamEncoder xmppStreamEncoder;
    private final Consumer<Throwable> onFailure;

    NettyXmppEncoder(BiConsumer<String, StreamElement> onWrite, Supplier<Marshaller> marshallerSupplier, Consumer<Throwable> onFailure) {
        this.onWrite = onWrite;
        this.xmppStreamEncoder = new XmppStreamEncoder(XMLOutputFactory.newFactory(), marshallerSupplier, Function.identity());
        this.onFailure = onFailure;
    }

    protected final void encode(ChannelHandlerContext ctx, StreamElement streamElement, ByteBuf byteBuf) throws Exception {
        try (ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);){
            this.xmppStreamEncoder.encode(streamElement, (OutputStream)outputStream);
            if (this.onWrite != null) {
                this.onWrite.accept(byteBuf.toString(StandardCharsets.UTF_8), streamElement);
            }
        }
    }

    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.onFailure != null) {
            this.onFailure.accept(cause);
        } else {
            super.exceptionCaught(ctx, cause);
        }
    }
}

