/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.nio.netty.net;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.compression.JdkZlibDecoder;
import io.netty.handler.codec.compression.JdkZlibEncoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLOutputFactory;
import rocks.xmpp.core.Session;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.ConnectionConfiguration;
import rocks.xmpp.core.net.ReaderInterceptor;
import rocks.xmpp.core.net.TcpConnection;
import rocks.xmpp.core.net.WriterInterceptor;
import rocks.xmpp.core.session.model.SessionOpen;
import rocks.xmpp.core.stream.StreamHandler;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamHeader;
import rocks.xmpp.nio.netty.net.NettyXmppDecoder;
import rocks.xmpp.nio.netty.net.NettyXmppEncoder;
import rocks.xmpp.util.XmppStreamEncoder;

public class NettyChannelConnection
extends TcpConnection {
    protected final Channel channel;
    private final NettyXmppDecoder decoder;
    protected SessionOpen sessionOpen;

    public NettyChannelConnection(Channel channel, StreamHandler streamHandler, Session session, List<ReaderInterceptor> readerInterceptors, Function<Locale, Unmarshaller> unmarshallerSupplier, List<WriterInterceptor> writerInterceptors, Supplier<Marshaller> marshallerSupplier, Consumer<Throwable> onException, ConnectionConfiguration connectionConfiguration) {
        super(connectionConfiguration, streamHandler, onException);
        this.channel = channel;
        this.decoder = new NettyXmppDecoder(arg_0 -> ((NettyChannelConnection)this).handleElement(arg_0), readerInterceptors, unmarshallerSupplier, onException, session, (Connection)this);
        ArrayList<WriterInterceptor> interceptors = new ArrayList<WriterInterceptor>(writerInterceptors);
        interceptors.add((WriterInterceptor)new XmppStreamEncoder(XMLOutputFactory.newFactory(), marshallerSupplier, s -> false));
        channel.pipeline().addLast(new ChannelHandler[]{this.decoder, new NettyXmppEncoder(interceptors, onException, session, (Connection)this)});
    }

    public static <T> CompletableFuture<T> completableFutureFromNettyFuture(Future<T> future) {
        CompletableFuture completableFuture = new CompletableFuture();
        future.addListener(f -> {
            if (f.isSuccess()) {
                completableFuture.complete(future.getNow());
            } else {
                completableFuture.completeExceptionally(future.cause());
            }
        });
        return completableFuture;
    }

    public final InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    public final CompletionStage<Void> open(SessionOpen sessionOpen) {
        this.sessionOpen = sessionOpen;
        return this.send((StreamElement)sessionOpen);
    }

    public final CompletionStage<Void> send(StreamElement streamElement) {
        return this.write(streamElement, arg_0 -> ((Channel)this.channel).writeAndFlush(arg_0));
    }

    public final CompletionStage<Void> write(StreamElement streamElement) {
        return this.write(streamElement, arg_0 -> ((Channel)this.channel).write(arg_0));
    }

    private CompletionStage<Void> write(StreamElement streamElement, Function<StreamElement, ChannelFuture> writeFunction) {
        if (!this.isClosed() || streamElement == StreamHeader.CLOSING_STREAM_TAG) {
            return NettyChannelConnection.completableFutureFromNettyFuture((Future)writeFunction.apply(streamElement));
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        completableFuture.completeExceptionally(new IllegalStateException("Connection closed"));
        return completableFuture;
    }

    public final void flush() {
        this.channel.flush();
    }

    public void secureConnection() throws Exception {
        SSLContext sslContext = this.getConfiguration().getSSLContext();
        JdkSslContext sslCtx = new JdkSslContext(sslContext, false, ClientAuth.NONE);
        SslHandler handler = new SslHandler(sslCtx.newEngine(this.channel.alloc()), true);
        this.channel.pipeline().addFirst("SSL", (ChannelHandler)handler);
    }

    public final void compressConnection(String method, Runnable onSuccess) {
        ChannelHandler channelHandler;
        ZlibWrapper zlibWrapper;
        switch (method) {
            case "zlib": {
                zlibWrapper = ZlibWrapper.ZLIB;
                break;
            }
            case "deflate": {
                zlibWrapper = ZlibWrapper.NONE;
                break;
            }
            case "gzip": {
                zlibWrapper = ZlibWrapper.GZIP;
                break;
            }
            default: {
                throw new IllegalArgumentException("Compression method '" + method + "' not supported");
            }
        }
        if (onSuccess != null) {
            onSuccess.run();
        }
        if ((channelHandler = this.channel.pipeline().get("SSL")) != null) {
            this.channel.pipeline().addAfter("SSL", "decompressor", (ChannelHandler)new JdkZlibDecoder(zlibWrapper));
            this.channel.pipeline().addAfter("SSL", "compressor", (ChannelHandler)new JdkZlibEncoder(zlibWrapper));
        } else {
            this.channel.pipeline().addFirst("decompressor", (ChannelHandler)new JdkZlibDecoder(zlibWrapper));
            this.channel.pipeline().addFirst("compressor", (ChannelHandler)new JdkZlibEncoder(zlibWrapper));
        }
    }

    public final boolean isSecure() {
        return this.channel.pipeline().toMap().containsKey("SSL");
    }

    protected void restartStream() {
        this.decoder.restart();
    }

    public final CompletionStage<Void> closeFuture() {
        return NettyChannelConnection.completableFutureFromNettyFuture(this.channel.closeFuture());
    }

    protected CompletionStage<Void> closeStream() {
        return this.send(StreamHeader.CLOSING_STREAM_TAG);
    }

    protected CompletionStage<Void> closeConnection() {
        return NettyChannelConnection.completableFutureFromNettyFuture(this.channel.close());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TCP connection to ").append(this.channel.remoteAddress());
        String streamId = this.getStreamId();
        if (streamId != null) {
            sb.append(" (").append(streamId).append(')');
        }
        sb.append(" using io.netty.channel.Channel");
        return sb.toString();
    }
}

