/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.nio.netty.net;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.xml.bind.Unmarshaller;
import rocks.xmpp.core.Session;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.ReaderInterceptor;
import rocks.xmpp.core.net.ReaderInterceptorChain;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.nio.codec.XmppStreamDecoder;

final class NettyXmppDecoder
extends ByteToMessageDecoder {
    private final List<ReaderInterceptor> readerInterceptors;
    private final XmppStreamDecoder xmppStreamDecoder;
    private final Consumer<Throwable> onFailure;
    private final Consumer<StreamElement> streamElementConsumer;
    private final Session session;
    private final Connection connection;

    NettyXmppDecoder(Consumer<StreamElement> streamElement, List<ReaderInterceptor> readerInterceptors, Function<Locale, Unmarshaller> unmarshallerSupplier, Consumer<Throwable> onFailure, Session session, Connection connection) {
        this.xmppStreamDecoder = new XmppStreamDecoder(unmarshallerSupplier);
        ArrayList<ReaderInterceptor> interceptors = new ArrayList<ReaderInterceptor>(readerInterceptors);
        interceptors.add((ReaderInterceptor)this.xmppStreamDecoder);
        this.readerInterceptors = interceptors;
        this.onFailure = onFailure;
        this.streamElementConsumer = streamElement;
        this.session = session;
        this.connection = connection;
    }

    protected final void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> list) throws Exception {
        ByteBuffer byteBuffer = byteBuf.nioBuffer();
        this.xmppStreamDecoder.decode(byteBuffer, (s, streamElement) -> {
            try (StringReader stringReader = new StringReader((String)s);){
                ReaderInterceptorChain readerInterceptorChain = new ReaderInterceptorChain(this.readerInterceptors, this.session, this.connection);
                readerInterceptorChain.proceed((Reader)stringReader, this.streamElementConsumer);
            }
            catch (Exception e) {
                throw new DecoderException((Throwable)e);
            }
        });
        byteBuf.readerIndex(byteBuffer.position());
    }

    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.onFailure != null) {
            this.onFailure.accept(cause);
        } else {
            super.exceptionCaught(ctx, cause);
        }
    }

    final void restart() {
        this.xmppStreamDecoder.restart();
    }
}

