/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.nio.netty.net;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import rocks.xmpp.core.Session;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.WriterInterceptor;
import rocks.xmpp.core.net.WriterInterceptorChain;
import rocks.xmpp.core.stream.model.StreamElement;

final class NettyXmppEncoder
extends MessageToByteEncoder<StreamElement> {
    private final Iterable<WriterInterceptor> writerInterceptors;
    private final Consumer<Throwable> onFailure;
    private final Session session;
    private final Connection connection;

    NettyXmppEncoder(Iterable<WriterInterceptor> writerInterceptors, Consumer<Throwable> onFailure, Session session, Connection connection) {
        this.writerInterceptors = writerInterceptors;
        this.onFailure = onFailure;
        this.session = session;
        this.connection = connection;
    }

    protected final void encode(ChannelHandlerContext ctx, StreamElement streamElement, ByteBuf byteBuf) throws Exception {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new ByteBufOutputStream(byteBuf), StandardCharsets.UTF_8);){
            WriterInterceptorChain chain = new WriterInterceptorChain(this.writerInterceptors, this.session, this.connection);
            chain.proceed(streamElement, (Writer)writer);
        }
    }

    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.onFailure != null) {
            this.onFailure.accept(cause);
        } else {
            super.exceptionCaught(ctx, cause);
        }
    }
}

