/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.websocket.net.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.net.ConnectionConfiguration;
import rocks.xmpp.core.net.ReaderInterceptor;
import rocks.xmpp.core.net.WriterInterceptor;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamHandler;
import rocks.xmpp.core.stream.client.StreamFeaturesManager;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.StreamFeatures;
import rocks.xmpp.extensions.sm.client.ClientStreamManager;
import rocks.xmpp.util.XmppStreamDecoder;
import rocks.xmpp.util.XmppStreamEncoder;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.QueuedScheduledExecutorService;
import rocks.xmpp.websocket.net.WebSocketConnection;
import rocks.xmpp.websocket.net.client.WebSocketConnectionConfiguration;

abstract class AbstractWebSocketClientConnection
extends WebSocketConnection {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool(XmppUtils.createNamedThreadFactory((String)"WebSocket Ping Scheduler"));
    private final StreamFeaturesManager streamFeaturesManager;
    private final ClientStreamManager streamManager;
    private final Set<String> pings = new CopyOnWriteArraySet<String>();
    private final URI uri;
    protected final XmppSession xmppSession;
    protected final List<WriterInterceptor> writerInterceptors;
    protected final List<ReaderInterceptor> readerInterceptors;
    protected ScheduledExecutorService executorService;
    protected Future<?> pingFuture;
    private Future<?> pongFuture;

    protected AbstractWebSocketClientConnection(WebSocketConnectionConfiguration connectionConfiguration, URI uri, XmppSession xmppSession, CompletionStage<Void> closeFuture) {
        super((ConnectionConfiguration)connectionConfiguration, (StreamHandler)xmppSession, arg_0 -> ((XmppSession)xmppSession).notifyException(arg_0), closeFuture);
        this.uri = uri;
        this.xmppSession = xmppSession;
        this.writerInterceptors = new ArrayList<WriterInterceptor>(xmppSession.getWriterInterceptors());
        this.writerInterceptors.add((WriterInterceptor)new XmppStreamEncoder(xmppSession.getConfiguration().getXmlOutputFactory(), () -> ((XmppSession)xmppSession).createMarshaller(), streamElement -> streamElement instanceof StreamFeatures || streamElement instanceof StreamError));
        this.readerInterceptors = new ArrayList<ReaderInterceptor>(xmppSession.getReaderInterceptors());
        this.readerInterceptors.add((ReaderInterceptor)new XmppStreamDecoder(xmppSession.getConfiguration().getXmlInputFactory(), () -> ((XmppSession)xmppSession).createUnmarshaller(), ""));
        this.streamFeaturesManager = (StreamFeaturesManager)xmppSession.getManager(StreamFeaturesManager.class);
        this.streamManager = (ClientStreamManager)xmppSession.getManager(ClientStreamManager.class);
        this.executorService = new QueuedScheduledExecutorService((Executor)EXECUTOR_SERVICE);
        if (connectionConfiguration.getPingInterval() != null && !connectionConfiguration.getPingInterval().isNegative() && !connectionConfiguration.getPingInterval().isZero()) {
            this.pingFuture = this.executorService.scheduleAtFixedRate(() -> {
                AbstractWebSocketClientConnection abstractWebSocketClientConnection = this;
                synchronized (abstractWebSocketClientConnection) {
                    try {
                        String uuid;
                        if (!this.isClosed() && this.pings.add(uuid = UUID.randomUUID().toString())) {
                            this.sendPing(ByteBuffer.wrap(uuid.getBytes(StandardCharsets.UTF_8)));
                            this.pongFuture = this.executorService.schedule(() -> {
                                if (this.pings.remove(uuid)) {
                                    xmppSession.notifyException((Throwable)new XmppException("No WebSocket pong received in time."));
                                }
                            }, xmppSession.getConfiguration().getDefaultResponseTimeout().toMillis(), TimeUnit.MILLISECONDS);
                        }
                    }
                    catch (IOException e) {
                        xmppSession.notifyException((Throwable)e);
                    }
                }
            }, 0L, connectionConfiguration.getPingInterval().toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    public final InetSocketAddress getRemoteAddress() {
        return InetSocketAddress.createUnresolved(this.uri.getHost(), this.uri.getPort());
    }

    public final boolean isUsingAcknowledgements() {
        return this.streamManager.isActive();
    }

    protected final void restartStream() {
        this.open(this.sessionOpen);
    }

    protected abstract void sendPing(ByteBuffer var1) throws IOException;

    protected void pongReceived(ByteBuffer message) {
        byte[] bytes = new byte[message.limit()];
        message.get(bytes);
        this.pings.remove(new String(bytes, StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCloseConnection() {
        this.streamFeaturesManager.removeFeatureNegotiator((StreamFeatureNegotiator)this.streamManager);
        AbstractWebSocketClientConnection abstractWebSocketClientConnection = this;
        synchronized (abstractWebSocketClientConnection) {
            if (this.pingFuture != null) {
                this.pingFuture.cancel(false);
                this.pingFuture = null;
            }
            if (this.pongFuture != null) {
                this.pongFuture.cancel(false);
                this.pongFuture = null;
            }
            if (this.executorService != null) {
                this.executorService.shutdown();
                try {
                    if (!this.executorService.awaitTermination(50L, TimeUnit.MILLISECONDS)) {
                        this.executorService.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    this.executorService.shutdownNow();
                    Thread.currentThread().interrupt();
                }
                this.executorService = null;
            }
        }
    }
}

